package com.elitesland.sale.api.vo.param.shop;

import com.elitesland.sale.api.AmtBigDecimalJsonDeserialize;
import com.elitesland.sale.api.PriceBigDecimalJsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 满减促销折扣信息明细 保存VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/18
 */
@ApiModel(description = "满减促销折扣信息明细 保存VO")
@Data
public class MktDiscountOffsetDSaveVO implements Serializable {

    private static final long serialVersionUID = 8166082748902249387L;

    @ApiModelProperty("明细表ID")
    private Long id;

    @ApiModelProperty("折扣满减ID")
    private Long mktDiscountOffsetId;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String itemAttr;

    @ApiModelProperty("计量单位")
    private String uom;

    @JsonDeserialize(using = AmtBigDecimalJsonDeserialize.class)
    @ApiModelProperty("满减达标金额")
    private BigDecimal limitAmt;

    @ApiModelProperty("满减达标数量")
    private Long limitNum;

    @JsonDeserialize(using = PriceBigDecimalJsonDeserialize.class)
    @ApiModelProperty("基础价格")
    private BigDecimal basePrice;

    @JsonDeserialize(using = PriceBigDecimalJsonDeserialize.class)
    @ApiModelProperty("客户价格")
    private BigDecimal custPrice;

    @JsonDeserialize(using = AmtBigDecimalJsonDeserialize.class)
    @ApiModelProperty("减免金额")
    private BigDecimal freeAmt;

    @JsonDeserialize(using = PriceBigDecimalJsonDeserialize.class)
    @ApiModelProperty("折扣后价格")
    private BigDecimal discountPrice;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

}
