package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Data;

@Data
@ApiModel(description = "卡券申领单展示")
public class SalMakeCardRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 7971853965370958839L;

    @ApiModelProperty("单据编码")
    private String docNo;

    @ApiModelProperty("单据状态 [UDC]SAL:SAL_BILL_STATUS")
    @SysCode(sys = "yst-sale", mod = "RECEIPT_STATUS")
    private String docStatus;

    @ApiModelProperty("单据状态 [UDC]SAL:SAL_BILL_STATUS")
    private String docStatusName;

    @ApiModelProperty("入库公司Id")
    private Long ouId;

    @ApiModelProperty("公司name")
    private String ouName;

    @ApiModelProperty("仓库Id")
    private Long whId;

    @ApiModelProperty("仓库code")
    private String whCode;

    @ApiModelProperty("仓库name")
    private String whName;

    @ApiModelProperty("商品种类类型")
    private Long itemTypeCount;

    @ApiModelProperty("卡数量")
    private Integer cardCount;

    @ApiModelProperty("审核人")
    private Long approvedUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("行数据")
    private List<SalMakeCardLineRespVO> salMakeCardLineRespVOS;




}
