package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Data
@ApiModel(description = "卡券申领单展示")
public class SalReceiveCardRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 7971853965370958839L;

    @ApiModelProperty("单据编码")
    private String docNo;

    @ApiModelProperty("单据状态 [UDC]SAL:SAL_BILL_STATUS")
    @SysCode(sys = "yst-sale", mod = "RECEIPT_STATUS")
    private String docStatus;

    @ApiModelProperty("单据状态 [UDC]SAL:SAL_BILL_STATUS")
    private String docStatusName;

    @ApiModelProperty("来源 [UDC]SAL:CARD_SOURCE")
    @SysCode(sys = "yst-sale", mod = "CARD_SOURCE")
    private String source;

    @ApiModelProperty("来源 [UDC]SAL:CARD_SOURCE")
    private String sorceName;

    @ApiModelProperty("领用公司Id")
    private Long receiveOuId;

    @ApiModelProperty("领用公司name")
    private String receiveOuCode;

    @ApiModelProperty("领用公司name")
    private String receiveOuName;

    @ApiModelProperty("领用仓库Id")
    private Long recevieWhId;

    @ApiModelProperty("领用仓库code")
    private String recevieWhCode;

    @ApiModelProperty("领用仓库name")
    private String recevieWhName;

    @ApiModelProperty("业务员ID")
    private Long agentEmpId;

    @ApiModelProperty("业务员Code")
    private String agentEmpCode;

    @ApiModelProperty("业务员Name")
    private String agentEmpName;

    @ApiModelProperty("领用卡数量")
    private Integer cardCount;

    @ApiModelProperty("审核人")
    private Long approvedUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime approvedTime;




}
