package com.elitesland.sale.api.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.param.sal.SalCardParam;
import com.elitesland.sale.api.vo.param.sal.SalMakeCardParam;
import com.elitesland.sale.api.vo.param.sal.SalReceiveCardParam;
import com.elitesland.sale.api.vo.param.sal.SalReceiveCardSaveParam;
import com.elitesland.sale.api.vo.resp.sal.SalMakeCardExportVO;
import com.elitesland.sale.api.vo.resp.sal.SalMakeCardLineRespVO;
import com.elitesland.sale.api.vo.resp.sal.SalMakeCardRespVO;
import com.elitesland.sale.api.vo.resp.sal.SalReceiveCardRespVO;
import java.time.LocalDateTime;
import java.util.List;

public interface SalMakeCardService {

    /**
     * 查询
     *
     * @param salMakeCardParam
     * @return
     */
    PagingVO<SalMakeCardRespVO> search(SalMakeCardParam salMakeCardParam);

    /**
     * 导出
     * @param salMakeCardParam
     * @return
     */
    PagingVO<SalMakeCardExportVO> export(SalMakeCardParam salMakeCardParam);


    /**
     * 保存
     * @param salMakeCardRespVO
     */
    void save(SalMakeCardRespVO salMakeCardRespVO);

    /**
     * 审核
     * @param salCardParam
     */
    void approve(SalCardParam<SalMakeCardRespVO>  salCardParam);


    /**
     * 拉取时间
     void     * @param startTime
     * @param endTime
     */
    Long pull(LocalDateTime startTime, LocalDateTime endTime);

    /**
     * 详情
     * @param masId
     * @return
     */
    SalMakeCardRespVO detail(Long masId);

    /**
     * 删除
     * @param docIds
     */
    void remove(List<Long> docIds);











}
