package com.elitesland.sale.api.vo.resp.crm;

import com.elitesland.sale.api.AmtBigDecimalJsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class MktDiscountGiftRpcDTO implements Serializable {
    private static final long serialVersionUID = 8211338135743802552L;

    @ApiModelProperty("满减赠促销id")
    private Long id;

    @ApiModelProperty("满减赠促销编码")
    private String code;

    @ApiModelProperty("满减赠促销名称")
    private String name;

    @ApiModelProperty("促销生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty("促销失效时间")
    private LocalDateTime validEtime;

    @ApiModelProperty("销售公司ID")
    private Long ouId;


    @ApiModelProperty("销售组织ID")
    private Long buId;


    @ApiModelProperty("促销条件:0 件数 1 金额")
    private String type;

    @ApiModelProperty("促销状态")
    private String status;





    @ApiModelProperty("商品Id")
    private Long itemId;



    @ApiModelProperty("商品编码")
    private String itemCode;



    @JsonDeserialize(using = AmtBigDecimalJsonDeserialize.class)
    @ApiModelProperty("满赠达标金额")
    private BigDecimal limitAmt;


    @ApiModelProperty("满赠达标数量")
    private Long limitNum;

    @ApiModelProperty("赠品")
    private List<GiftRpcDTO> gifts;


}
