package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
@ApiModel(description = "卡券领用单展示")
public class SalReceiveCardExportVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 7971853965370958839L;

    @ApiModelProperty("单据编码")
    private String docNo;

    @ApiModelProperty("单据状态 [UDC]SAL:CARD_DOC_STATUS")
    @SysCode(sys = "yst-sale", mod = "CARD_DOC_STATUS")
    private String docStatus;

    @ApiModelProperty("单据状态 [UDC]SAL:CARD_DOC_STATUS")
    private String docStatusName;

    @ApiModelProperty("公司Id")
    private Long receiveOuId;

    @ApiModelProperty("公司name")
    private String ouName;

    @ApiModelProperty("公司code")
    private String ouCode;

    @ApiModelProperty("仓库Id")
    @NotNull(message = "仓库不可为空")
    private Long recevieWhId;

    @ApiModelProperty("仓库code")
    private String whCode;

    @ApiModelProperty("仓库name")
    private String whName;


    private Long agentEmpId;

    @ApiModelProperty("业务员Code")
    private String agentEmpCode;

    @ApiModelProperty("业务员Name")
    private String agentEmpName;

    @ApiModelProperty("卡号")
    private String cardNo;

    @ApiModelProperty("卡状态")
    private String cardStatus;

    @ApiModelProperty("卡状态")
    private String cardStatusName;

    @ApiModelProperty("商品name")
    private String itemName;

    @ApiModelProperty("商品code")
    private String itemCode;

    @ApiModelProperty(value = "已生成订单")
    private Boolean createdOrder;









}
