package com.elitesland.sale.api.vo.resp.sal;

import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@ApiModel(description = "卡快速生成订单")
@Builder
public class SalReceiveCardOrderVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 7971853965370958839L;

    @ApiModelProperty(value = "错误信息")
    private List<ErrorInfo> errorInfos;

    private Long orderId;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ErrorInfo {

        private String cardNo;

        private String errorMessage;

    }

}
