package com.elitesland.sale.api.vo.resp.crm;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@ApiModel(description = "客户信息")
@Data
public class CrmCustPageRespVO implements Serializable {

    private static final long serialVersionUID = 5227112878291233500L;
    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户联系人")
    private String contPerson;

    @ApiModelProperty(value = "客户联系人手机")
    private String contPersonMobile;

    @ApiModelProperty(value = "客户联系人电话")
    private String contPersonTel;

    @ApiModelProperty(value = "客户联系人邮箱")
    private String contPersonEmail;

    @ApiModelProperty(value = "客户联系人省市区")
    private List<String> contractCity;
    private String contractCityName;

    @ApiModelProperty(value = "客户联系人详细地址")
    private String addrDetail;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty(value = "地址簿Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    @ApiModelProperty(value = "项目公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "项目公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售组织id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "销售组织编码")
    private String buCode;

    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty(value = "区域 []yst-supp:REGION")
    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;
    private String regionName;

    @ApiModelProperty(value = "业务员id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "业务员编码")
    private String agentEmpCode;

    @ApiModelProperty(value = "业务员名称")
    private String agentEmpName;

    @ApiModelProperty(value = "客户分类 [UDC]CRM:CUST_TYPE")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custType;
    private String custTypeName;

    @ApiModelProperty(value = "客户归类 [UDC]CRM:CUST_TYPE2")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE2")
    private String custType2;
    private String custType2Name;

    @ApiModelProperty(value = "客户状态 [UDC]yst-sale:CUST_STATUS")
    @SysCode(sys = "yst-sale", mod = "CUST_STATUS")
    private String custStatus;
    private String custStatusName;

    @ApiModelProperty(value = "客户等级")
    @SysCode(sys = "yst-sale", mod = "CUST_LEVEL")
    private String custLevel;
    private String custLevelName;

//    @ApiModelProperty(value = "同步状态 [UDC]COM:INTF_STATUS")
//    @SysCode(sys = "yst-supp",mod = "INTF_STATUS")
//    private String intfStatus;
//    private String intfStatusName;

//    @ApiModelProperty(value = "参保信息 [UDC]CRM:INSURED")
//    @SysCode(sys = "yst-sale", mod = "INSURED")
//    private String insured;
//    private String insuredName;

    @ApiModelProperty(value = "客户来源 [UDC]CRM:CUST_SOURCE")
    @SysCode(sys = "yst-sale", mod = "CUST_SOURCE")
    private String custSource;
    private String custSourceName;


    @ApiModelProperty(value = "外部系统客户编码")
    private String custCode2;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "客户行业 [UDC]COM:INDUSTRY")
    @SysCode(sys = "yst-supp", mod = "INDUSTRY")
    private String custIndustry;
    private String custIndustryName;

    @ApiModelProperty(value = "客户规模 [UDC]CRM:CUST_SCALE")
    @SysCode(sys = "yst-sale", mod = "CUST_SCALE")
    private String compScale;
    private String compScaleName;


    @ApiModelProperty(value = "客户年营业额")
    private String compTurnover;

    @ApiModelProperty(value = "发票类型 [UDC]CRM:INV_TYPE")
    @SysCode(sys = "yst-supp", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "税号")
    private String taxerNo;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    @ApiModelProperty(value = "银行账户")
    private String invBankAcc;

    @ApiModelProperty(value = "联系人")
    private String invPicName;

    @ApiModelProperty(value = "付款条款")
    @SysCode(sys = "yst-supp", mod = "PAYMENT_TERM")
    private String paymentTerm;
    private String paymentTermName;


    @ApiModelProperty("B端商城联系人电话")
    private String contactPhone;

    @ApiModelProperty("B端商城联系人姓名")
    private String contactName;

    @ApiModelProperty(value = "乡镇/街道")
    private String street;

    @ApiModelProperty(value = "客户联系人传真")
    private String contPersonFax;


    //lm
    @ApiModelProperty(value = "K3客户编码")
    private String outerCode;
    @ApiModelProperty(value = "客户分类")
    private String custGroup;
    private String custGroupName;

    @ApiModelProperty(value = "父项客户编号")
    private String pid;

    @ApiModelProperty(value = "父项客户号")
    private String pid2;
    private String pidName;
    @ApiModelProperty(value = "统一社会信用代码")
    private String certNo;
    @ApiModelProperty(value = "结算币种")
    private String custCurr;
    @ApiModelProperty(value = "结算币种")
    private String custCurrName;

    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerType;
    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerTypeName;

//    @ApiModelProperty(value = "是否创建公司 0：否 1：是")
//    private Integer isCreateOu;
//
//    @ApiModelProperty(value = "是否创建公司 0：否 1：是")
//    private String isCreateOuName;

    @ApiModelProperty(value = "错误信息")
    private String es1;

    @ApiModelProperty(value = "公司编码（财务用）")
    private String ouCode;

    @ApiModelProperty(value = "对应公司")
    private String corBusinCode;

    @ApiModelProperty(value = "客户登录帐号")
    private String userName;

    @ApiModelProperty(value = "开票联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "允发最大批次数量")
    @SysCode(sys = "yst-sale", mod = "ALLOW_SHIP_BATCH_MAX")
    private String allowBatchMax;
    private String allowBatchMaxName;

    @ApiModelProperty(value = "默认允发期code")
    private String allowShipRuleCode;

    @ApiModelProperty(value = "默认允发期code")
    private String allowShipRuleName;


    @ApiModelProperty("渠道 yst-supp:SALE_CHANNEL")
    private String saleChannel;
    private String saleChannelName;
    @ApiModelProperty("默认配送方式 yst-order:SO_DELIVER_METHOD")
    private String deliverMethod;
    private String deliverMethodName;

    @ApiModelProperty("承运信息")
    private String carrier;
}
