package com.elitesland.sale.api.vo.resp.component;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/6/25
 */
@Data
@ApiModel("业务员公共组件分页VO")
public class SalesmanPageRespVO implements Serializable {
    private static final long serialVersionUID = -8634920363032431031L;

    /**
     * 员工ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("业务员ID")
    private Long id;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "业务员编号")
//    private String empCode;
    private String salesmanNo;


    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "业务员姓名")
//    private String empName;
    private String name;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属组织ID")
    private Long orgId;

    /**
     * 所属组织编号
     */
    @ApiModelProperty(value = "所属组织编号")
    private String buCode;

    /**
     * 所属组织名称
     */
    @ApiModelProperty(value = "所属组织名称")
    private String orgName;

    /**
     * 所属公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属公司ID")
    private Long ouId;

    /**
     * 所属公司名称
     */
    @ApiModelProperty(value = "所属公司名称")
    private String ouName;

    /**
     * 所属公司编号
     */
    @ApiModelProperty(value = "所属公司编号")
    private String ouCode;

    /**
     * 公司本位币
     */
    @ApiModelProperty(value = "公司本位币")
    private String currCode;
    @ApiModelProperty(value = "公司本位币名称")
    private String currName;

    /**
     * 员工绑定的用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "业务员绑定的用户ID")
    private Long userId;

    /**
     * 员工绑定的用户名
     */
    @ApiModelProperty(value = "业务员绑定的用户名")
    private String userName;

    @ApiModelProperty(value = "登录账号")
    private String loginAccount;


    @ApiModelProperty(value = "业务员类型")
    private String salesmanTypeList;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "上级")
    private String leaderName;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;
    private String enableStatusName;


    /**
     * 地址号
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("地址号")
    private Long addrNo;

}
