package com.elitesland.sale.api.vo.save;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


@Data
@ApiModel(description = "")
public class CrmCustImportVO implements Serializable {
    private static final long serialVersionUID = -8587166213133995987L;



    @ApiModelProperty(value = "客户归类")
    @ExcelProperty(index = 0)
    private String custType2Name;

    private String custType2;

    @ApiModelProperty(value = "客户编码")
    @ExcelProperty(index = 1)
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    @ExcelProperty(index = 2)
    private String custName;

    @ApiModelProperty(value = "客户类型")
    @ExcelProperty(index = 3)
//    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custTypeName;
    private String custType;

    @ApiModelProperty(value = "税务登记号")
    @ExcelProperty(index = 4)
    private String taxerNo;


    @ApiModelProperty(value = "客户简称")
    @ExcelProperty(index = 5)
    private String custAbbr;

    @ApiModelProperty(value = "英文名称")
    @ExcelProperty(index = 6)
    private String custName2;

    @ApiModelProperty(value = "客户登录账号")
    @ExcelProperty(index = 7)
    private String userName;

    @ApiModelProperty("客户联系人")
    @ExcelProperty(index = 8)
    private String contactName;

    @ApiModelProperty("客户联系电话")
    @ExcelProperty(index = 9)
    private String contactPhone;

    @ApiModelProperty(value = "公司编号")
    @ExcelProperty(index = 10)
    private String ouCode;

    private Long ouId;

    private String ouName;

    @ApiModelProperty(value = "销售组织")
    @ExcelProperty(index = 11)
    private String buCode;

    private Long buId;

    private String buName;

    @ApiModelProperty(value = "区域")
    @ExcelProperty(index = 12)
    private String regionName;

    private String region;

    @ApiModelProperty(value = "业务员编码")
    @ExcelProperty(index = 13)
    private String agentEmpCode;

    private Long agentEmpId;

    @ApiModelProperty(value = "客户行业")
    @ExcelProperty(index = 14)
    private String custIndustryName;
    private String custIndustry;

    @ApiModelProperty(value = "客户等级")
    @ExcelProperty(index = 15)
    private String custLevelName;
    private String custLevel;

    @ApiModelProperty(value = "客户来源 yst-sale:CUST_SOURCE")
    @ExcelProperty(index = 16)
    private String custSourceName;
    private String custSource;

//    @ApiModelProperty(value = "客户规模")
//    private String compScale;

    @ApiModelProperty(value = "客户规模 [UDC]yst-sale:CUST_SCALE")
    @ExcelProperty(index = 17)
    private String compScaleName;
    private String compScale;
    @ApiModelProperty(value = "客户年营业额")
    @ExcelProperty(index = 18)
    private String compTurnover;

    @ApiModelProperty(value = "默认允发期编码")
    @ExcelProperty(index = 19)
    private String allowShipRuleCode;

    @ApiModelProperty("允发最大批次数量")
    @ExcelProperty(index = 20)
    private String allowBatchMaxName;
    private String allowBatchMax;

    @ApiModelProperty(value = "发票类型 [UDC]COM:INV_TYPE")
    @ExcelProperty(index = 21)
    private String invTypeName;
    private String invType;


    @ApiModelProperty(value = "开票抬头")
    @ExcelProperty(index = 22)
    private String invTitle;

    @ApiModelProperty(value = "统一社会信用代码")
    @ExcelProperty(index = 23)
    private String certNo;


    @ApiModelProperty(value = "开票地址")
    @ExcelProperty(index = 24)
    private String invAddress;


    @ApiModelProperty(value = "开票电话")
    @ExcelProperty(index = 25)
    private String invTel;


    @ApiModelProperty(value = "开户银行")
    @ExcelProperty(index = 26)
    private String invBankName;

    @ApiModelProperty(value = "银行账户")
    @ExcelProperty(index = 27)
    private String invBankAcc;



    @ApiModelProperty(value = "开票联系人")
    @ExcelProperty(index = 28)
    private String invPicName;

    @ApiModelProperty("开票联系人电话")
    @ExcelProperty(index = 29)
    private String invPicPhone;

    @ApiModelProperty(value = "付款条款 yst-supp:PAYMENT_TERM")
    @ExcelProperty(index = 30)
    private String paymentTermName;
    private String paymentTerm;

    @ApiModelProperty("渠道 yst-supp:SALE_CHANNEL")
    @ExcelProperty(index = 31)
    private String saleChannelName;
    private String saleChannel;

    @ApiModelProperty("默认配送方式 yst-order:SO_DELIVER_METHOD")
    @ExcelProperty(index = 32)
    private String deliverMethodName;
    private String deliverMethod;

    @ApiModelProperty("承运信息")
    @ExcelProperty(index = 33)
    private String carrier;


    @ApiModelProperty(value = "地址类型名称")
    @ExcelProperty(index = 34)
    private String addressTypeName;

    @ApiModelProperty(value = "是否默认")
    @ExcelProperty(index = 35)
    private String defaultFlagName;
    private Boolean defaultFlag;

    @ApiModelProperty(value = "联系人")
    @ExcelProperty(index = 36)
    private String contPerson;


    @ApiModelProperty(value = "联系人手机")
    @ExcelProperty(index = 37)
    private String contMobile;

    @ApiModelProperty(value = "联系人邮箱")
    @ExcelProperty(index = 38)
    private String email;

    @ApiModelProperty(value = "国家")
    @ExcelProperty(index = 39)
    private String countryName;

    @ApiModelProperty(value = "省")
    @ExcelProperty(index = 40)
    private String provinceName;

    @ApiModelProperty(value = "市")
    @ExcelProperty(index = 41)
    private String cityName;

    @ApiModelProperty(value = "区/县")
    @ExcelProperty(index = 42)
    private String countyName;

    @ApiModelProperty(value = "乡镇/街道")
    @ExcelProperty(index = 43)
    private String street;

    @ApiModelProperty(value = "详细地址")
    @ExcelProperty(index = 44)
    private String detailaddr;

    @ApiModelProperty("邮政编码")
    @ExcelProperty(index = 45)
    private String zipCode;


    @ApiModelProperty("账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    @ExcelProperty(index = 46)
    private String accTypeName;

    @ApiModelProperty(value = "银行信息是否默认")
    @ExcelProperty(index = 47)
    private String accDefaultFlagName;


    @ApiModelProperty(value = "收付款方式 [UDC]COM:PAY_METHOD")
    @ExcelProperty(index = 48)
//    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String payCollectMethodName;

    @ApiModelProperty("开户行")
    @ExcelProperty(index = 49)
    private String bankName;

    @ApiModelProperty("支行")
    @ExcelProperty(index = 50)
    private String branchName;


    @ApiModelProperty("开户行账号")
    @ExcelProperty(index = 51)
    private String bankAcc;


    @ApiModelProperty("开户人姓名")
    @ExcelProperty(index = 52)
    private String holderName;

    /**
     * 币种
     */
    @ApiModelProperty("币种")
    @ExcelProperty(index = 53)
    private String currName;

    @ApiModelProperty(value = "客户状态")
    private String custStatus;
}
