package com.elitesland.sale.service;


import com.elitesland.sale.Application;
import com.elitesland.sale.api.vo.param.crm.AllowShipCustGroupDParam;
import com.elitesland.sale.api.vo.param.crm.AllowShipCustGroupParam;
import com.elitesland.sale.api.vo.resp.crm.AllowShipCustGroupDVO;
import com.elitesland.sale.api.vo.resp.crm.AllowShipCustGroupRespVO;
import com.elitesland.sale.api.vo.resp.crm.AllowShipRuleCustItemVO;
import com.elitesland.sale.api.vo.resp.crm.AllowShipRuleRespVO;
import com.elitesland.sale.dto.param.AllowShipRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = Application.NAME, path = AllowShipRpcService.URI)
public interface AllowShipRpcService {

    String URI = Application.URI_PREFIX + "/allowShip";



    @PostMapping("/getAllowRule")
    public List<AllowShipRuleCustItemVO> getAllowShipSale(@RequestBody List<AllowShipRpcParam> param);





    @PostMapping("/getCustGroup")
    List<AllowShipCustGroupRespVO> getCustGroup(@RequestBody AllowShipCustGroupParam param);


    @PostMapping("/getCustGroupInfo")
    List<AllowShipCustGroupDVO> getCustGroupInfo(@RequestBody AllowShipCustGroupDParam param);
}
