package com.elitesland.sale.api.vo.param.crm;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * .
 *
 * @author Evin.dong
 * @date 2021-05-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "客户弹框选择查询入参")
public class CrmCustPlugInParamVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -8525814237219243163L;
    @ApiModelProperty(value = "客户编号/名称")
    private String custData;

    @ApiModelProperty(value = "客户类型")
    private String custType;

    @ApiModelProperty(value = "业务员code")
    @JsonSerialize(using = ToStringSerializer.class)
    private String agentEmpCode;

    @ApiModelProperty(value = "项目公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "是否是内部用户 true: 是, false: 否")
    private Boolean innerFlag;

    @ApiModelProperty("客户归类")
    private String custType2;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("客户状态")
    private String custStatus;

    @ApiModelProperty("客户归类列表")
    private List<String> custType2List;

    @ApiModelProperty("客户类型查询列表")
    private List<String> custTypeList;

    @ApiModelProperty("区域列表")
    private List<String> regionList;

    @ApiModelProperty("客户状态列表")
    private List<String> custStatusList;

    @ApiModelProperty("是否包含业务员为空的客户 默认为 false，传true 时结果集需要包含业务员为空的客")
    private Boolean isIncludeEmptySalesman;
    
    @ApiModelProperty("客户定义")
    private String custDef;
}
