package com.elitesland.sale.api.vo.save;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.convert.BooleanToIntegerConverter;
import com.elitesland.sale.api.vo.resp.crm.CustAccountVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Convert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Evin.dong
 * @date 2021-05-19
 */
@Data
@ApiModel(description = "客户表新增编辑入参")
public class CrmCustSaveVO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -6580640909133208873L;

//    @ApiModelProperty(value = "客户id")
//    @JsonSerialize(using = ToStringSerializer.class)
//    private Long id;
    
    @ApiModelProperty("客户定义")
    private String custDef;
    
    @ApiModelProperty("销售模式")
    private String saleMode;
    
    @ApiModelProperty("法人代表")
    private String repr;
    
    @ApiModelProperty("法人联系方式")
    private String reprCertMobile;
    
    @ApiModelProperty("合同起始日期")
    private String es1;
    
    @ApiModelProperty("合同结束日期")
    private String es2;
    @ApiModelProperty(value = "客户编码")
    private String custCode;
    @ApiModelProperty(value = "客户编码")
    private String custCode2;
    @ApiModelProperty(value = "外部系统编码")
    private String outerCode;

    @ApiModelProperty(value = "登录账号")
    private String userName;


    @ApiModelProperty(value = "地址簿ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "工商登记号")
    private String icRegisterNo;

    @ApiModelProperty(value = "客户名称", required = true)
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司编号", required = true)
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售组织ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    @ApiModelProperty(value = "销售组织编号")
    private String buCode;
    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty(value = "区域", required = true)
    private String region;

    @ApiModelProperty(value = "客户管理专员id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "业务员code")
    private String agentEmpCode;

    @ApiModelProperty(value = "客户分类")
    private String custType;

    @ApiModelProperty(value = "客户状态")
    private String custStatus;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "客户行业")
    private String custIndustry;

    @ApiModelProperty(value = "客户来源")
    private String custSource;

    @ApiModelProperty(value = "客户规模")
    private String compScale;

    @ApiModelProperty(value = "客户年营业额")
    private String compTurnover;

    @ApiModelProperty(value = "客户归类")
    private String custType2;

    @ApiModelProperty(value = "发票类型")
    private String invType;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    @ApiModelProperty(value = "银行账户")
    private String invBankAcc;

    @ApiModelProperty(value = "联系人")
    private String invPicName;

    @ApiModelProperty(value = "联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "付款条款 yst-supp:PAYMENT_TERM")
    private String paymentTerm;


    @ApiModelProperty(value = "父项客户号")
    private String pid;

    @ApiModelProperty(value = "默认税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "客户地址列表数据")
    private List<CrmCustAddrSaveVO> addrList;

    @ApiModelProperty(value = "证照信息列表数据")
    private List<CrmCustQualifySaveVO> qualifyList;

    /**
     * 银行信息保存列表
     */
    @ApiModelProperty("银行信息保存列表")
    List<OrgAddrBankAccSaveVO> orgAddrBankAccList;

    @ApiModelProperty(value = "客户详情")
    private String custDesc;

    @ApiModelProperty(value = "客户首次创建方")
    private Integer createdBy;

    @ApiModelProperty("联系人电话")
    private String contactPhone;

    @ApiModelProperty("联系人姓名")
    private String contactName;


    private CustAccountVO custAccountVO;


    @ApiModelProperty("统一信用代码")
    private String certNo;


    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerType;
    @ApiModelProperty(value = "客户分类")
    private String custGroup;

    @ApiModelProperty(value = "结算币种")
    private String custCurr;

    @ApiModelProperty(value = "税号")
    private String taxerNo;


    @ApiModelProperty(value = "同步状态")
    private String intfStatus;


    @ApiModelProperty("默认允发期code")
    private String allowShipRuleCode;

    @ApiModelProperty("允发最大批次数量")
    private String allowBatchMax;

    @ApiModelProperty("交货清单")
    List<DeliveryListSaveVO> deliveryList;

    @ApiModelProperty("默认配送方式 yst-order:SO_DELIVER_METHOD")
    private String deliverMethod;



    @ApiModelProperty("渠道 yst-supp:SALE_CHANNEL")
    private String saleChannel;



    @ApiModelProperty("承运信息")
    private String carrier;
}
