package com.elitesland.sale.api.vo.param.salesman;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanInfoQueryVO
 * @Date2023/2/20 11:37
 */
@Data
@ApiModel("业务员信息查询参数")
public class SalesmanInfoQueryVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 6698872187328873039L;
    @ApiModelProperty("业务员")
    private String salesman;

    @ApiModelProperty("组织")
    private String buCode;

    @ApiModelProperty("组织id")
    private String orgId;

    @ApiModelProperty("所属公司")
    private String ouCode;

    @ApiModelProperty("业务员类型")
    private String salesmanType;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;

    @ApiModelProperty("登录账号")
    private String loginAccount;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("是否无条件查询 1-是 0-否")
    private Integer noQueryParam;

    @ApiModelProperty("业务员编号集合")
    private List<String> codes;

}

