package com.elitesland.sale.api.vo.resp.itm;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * es专用
 * @author : 常浩波
 * @date 2023/03/08
 */
@Data
public class ItmItemSkuEsVO implements Serializable {

    private static final long serialVersionUID = 6797097119831818255L;

    private Long id;

    /**
     * SKU商品编号
     */
    private String itemCode;

    /**
     * 商品规格(JSON格式)
     * [{"code":"200007","name":"尺码","value":"1"}]
     */
    private String itemAttr;

    /**
     * itemAttr转map
     */
    private Map<String, String> itemAttrMap;

    /**
     * SKU商品名称
     */
    private String itemName;

    /**
     * 条码
     */
    private String barCode;

    /**
     * 规格型号
     */
    private String spec;

    /**
     * SKU 图片
     */
    private List<ItmItemAttachmentEsVO> skuImages;

    /**
     * 即将下架日期
     */
    private LocalDateTime expRemovx;
}
