package com.elitesland.sale.api.vo.resp.contract;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 返回参数 - 销售合同分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 7:21 下午
 */
@ApiModel(description = "销售合同分页查询返回参数")
@Data
public class SaleContractPageRespVO implements Serializable {

    private static final long serialVersionUID = -7988495247117046710L;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("公司id")
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户id")
    private Long custId;
    @ApiModelProperty("客户编码")
    private String custCode;
    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("合同名称")
    private String docName;

    @ApiModelProperty("合同编号")
    private String docNo;


    @ApiModelProperty("合同类型 [UDC]yst-sale:SALE_CONTRACT_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("签订日期")
    private LocalDateTime docDate;
    @ApiModelProperty("合同状态 [UDC]yst-sale:SALE_CONTRACT_STATUS")
    private String docStatus;
    private String docStatusName;

    /*@ApiModelProperty("付款协议类型")
    private String protocolType;
    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty("付款协议名称")
    private String protocolName;*/

    @ApiModelProperty("签订地点")
    private String signPlace;
    @ApiModelProperty("合同模板")
    @SysCode(sys = "yst-sale", mod = "SALE_CONTRACT_TEMPLATE")
    private String saleContractTemplate;
    private String saleContractTemplateName;
    @ApiModelProperty("合同来源")
    @SysCode(sys = "yst-sale", mod = "SALE_CONTRACT_SOURCE")
    private String saleContractSource;
    private String saleContractSourceName;
    @ApiModelProperty("合同金额")
    private BigDecimal amt;
    @ApiModelProperty("合同金额大写")
    private String amtUpper;
    @ApiModelProperty("结算方式")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String settleType;
    private String settleTypeName;
    @ApiModelProperty("起效日期")
    @SysCode(sys = "yst-fin", mod = "AGREEMENT_EFFECTIVE_DATE_TYPE")
    private String agreementEffectiveDateType;
    private String agreementEffectiveDateTypeName;
    @ApiModelProperty("账期天数")
    private Integer ardays;
    /*@ApiModelProperty("收款方式 [UDC]yst-supp:PAY_METHOD")
    private String payMethod;
    private String payMethodName;*/
    // @ApiModelProperty("流程实例状态[UDC]yst-sale:SALE_CONTRACT_APPLY_STATUS")
    // private String procInstStatus;
    // private String procInstStatusName;
    @ApiModelProperty("版本号")
    private BigDecimal versionNo;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("发货要求1")
    private String deliverInstruct;
    @ApiModelProperty("发货要求2")
    private String deliverInstruc2;
    @ApiModelProperty("是否归档")
    @SysCode(sys = "yst-purc", mod = "TRUE_OR_FALSE")
    private String archiveFlag;
    private String archiveFlagName;
    @ApiModelProperty("归档日期")
    private LocalDateTime archiveDate;
    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("业务员id")
    private Long agentEmpId;
    @ApiModelProperty("业务员编码")
    private String agentEmpCode;
    @ApiModelProperty("业务员名称")
    private String agentEmpName;
    @ApiModelProperty("创建人")
    private String creator;
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty("更新人")
    private String updater;
    @ApiModelProperty("更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("流程实例ID")
    private String procInstId;
    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;
    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;
    @ApiModelProperty("审批人")
    private Long apprUserId;
    @ApiModelProperty("审批人")
    private String apprUserName;
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;


    // 公司基本信息
    @ApiModelProperty(value = "公司基本信息-法人代表")
    private String ouReprName;
    @ApiModelProperty(value = "公司基本信息-纳税人识别号")
    private String ouCertNo;
    @ApiModelProperty(value = "公司基本信息-开户银行")
    private String ouBankName;
    @ApiModelProperty(value = "公司基本信息-支行")
    private String ouBranchName;
    @ApiModelProperty(value = "公司基本信息-银行账号")
    private String ouBankAcc;
    @ApiModelProperty(value = "公司基本信息-联系人")
    private String ouContact;
    @ApiModelProperty(value = "公司基本信息-联系电话")
    private String ouMobile;
    @ApiModelProperty(value = "公司基本信息-联系人邮箱")
    private String ouEmail;
    @ApiModelProperty(value = "公司基本信息-国家")
    private String ouCountry;
    @ApiModelProperty(value = "公司基本信息-省")
    private String ouProvince;
    @ApiModelProperty(value = "公司基本信息-市")
    private String ouCity;
    @ApiModelProperty(value = "公司基本信息-区")
    private String ouCounty;
    @ApiModelProperty(value = "公司基本信息-地址")
    private String ouAddress;

    @ApiModelProperty("公司基本信息-发货人姓名")
    private String ouShipContact;
    @ApiModelProperty("公司基本信息-发货人电话")
    private String ouShipMobile;
    @ApiModelProperty("公司基本信息-发货人邮箱")
    private String ouShipEmail;
    @ApiModelProperty(value = "公司基本信息-发货人国家")
    private String ouShipCountry;
    @ApiModelProperty(value = "公司基本信息-发货人省")
    private String ouShipProvince;
    @ApiModelProperty(value = "公司基本信息-发货人市")
    private String ouShipCity;
    @ApiModelProperty(value = "公司基本信息-发货人区")
    private String ouShipCounty;
    @ApiModelProperty(value = "公司基本信息-发货人地址")
    private String ouShipAddress;

    // 客户基本信息
    @ApiModelProperty(value = "供应商基本信息-法人代表")
    private String custReprName;
    @ApiModelProperty(value = "供应商基本信息-纳税人识别号")
    private String custCertNo;
    @ApiModelProperty(value = "供应商基本信息-开户银行")
    private String custBankName;
    @ApiModelProperty(value = "供应商基本信息-支行")
    private String custBranchName;
    @ApiModelProperty(value = "供应商基本信息-银行账号")
    private String custBankAcc;
    @ApiModelProperty(value = "供应商基本信息-联系人")
    private String custContact;
    @ApiModelProperty(value = "供应商基本信息-联系电话")
    private String custMobile;
    @ApiModelProperty(value = "供应商基本信息-联系人邮箱")
    private String custEmail;
    @ApiModelProperty(value = "供应商基本信息-国家")
    private String custCountry;
    @ApiModelProperty(value = "供应商基本信息-省")
    private String custProvince;
    @ApiModelProperty(value = "供应商基本信息-市")
    private String custCity;
    @ApiModelProperty(value = "供应商基本信息-区")
    private String custCounty;
    @ApiModelProperty(value = "供应商基本信息-地址")
    private String custAddress;

    @ApiModelProperty("供应商基本信息-收货人姓名")
    private String custRecvContact;
    @ApiModelProperty("供应商基本信息-收货人电话")
    private String custRecvMobile;
    @ApiModelProperty("供应商基本信息-收货人邮箱")
    private String custRecvEmail;
    @ApiModelProperty(value = "供应商基本信息-收货人国家")
    private String custRecvCountry;
    @ApiModelProperty(value = "供应商基本信息-收货人省")
    private String custRecvProvince;
    @ApiModelProperty(value = "供应商基本信息-收货人市")
    private String custRecvCity;
    @ApiModelProperty(value = "供应商基本信息-收货人区")
    private String custRecvCounty;
    @ApiModelProperty(value = "供应商基本信息-收货人地址")
    private String custRecvAddress;


    // 交付约定
    @ApiModelProperty(value = "交货方式")
    @SysCode(sys = "yst-purc", mod = "DELIVERY_METHOD")
    private String deliveryMethod;
    private String deliveryMethodName;

    @ApiModelProperty(value = "交货期限")
    private String deliveryDeadline;

    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp", mod = "TP_TYPE")
    private String transType;
    private String transTypeName;

    @ApiModelProperty(value = "运费承担方")
    @SysCode(sys = "yst-purc", mod = "FREIGHT_PAYER")
    private String freightPayer;
    private String freightPayerName;

    @ApiModelProperty(value = "交货地点")
    private String deliveryLocation;

    // 验收约定
    @ApiModelProperty(value = "验收期限（天）")
    private Integer acceptanceTerm;

    @ApiModelProperty(value = "调整换货期限（天）")
    private Integer exchangeTerm;

    @ApiModelProperty(value = "验收不合格处理方式")
    @SysCode(sys = "yst-purc", mod = "UNQUALIFIED_HANDLING")
    private String unqualifiedHandling;
    private String unqualifiedHandlingName;

    @ApiModelProperty(value = "隐藏缺陷发现期限（天）")
    private Integer hiddenDefectTerm;

    @ApiModelProperty(value = "验收质量标准")
    private String acceptanceStandard;

    // 付款约定
    @ApiModelProperty(value = "付款方式：UDC:yst-sale:PAYMENT_METHOD")
    @SysCode(sys = "yst-sale", mod = "PAYMENT_METHOD")
    private String paymentMethod;
    private String paymentMethodName;

    @ApiModelProperty(value = "付款期限（天）")
    private Integer payTerm;

    @ApiModelProperty(value = "预付款比例（%）")
    private BigDecimal prepaymentRatio;

    @ApiModelProperty("开票期限")
    private Integer invoiceTerm;
}
