package com.elitesland.sale.api.vo.param.special;

import com.elitesland.sale.api.vo.resp.shop.FirstSpecialItemVO;
import com.elitesland.sale.api.vo.resp.shop.app.BipItemDetailAppRespVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 首单特惠
 */
@Data
@ApiModel(description = "首单特惠小程序")
public class FirstSpecialItemAppVO implements Serializable {

	private static final long serialVersionUID = 4383492602319602872L;
	@ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("ouId")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("基础价格")
    private BigDecimal basePrice;

    @ApiModelProperty("特惠价格")
    private BigDecimal preferentialPrice;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-sale", mod = "SPECIAL_STATUS")
    private String status;
    private String statusName;


    @ApiModelProperty("优先级")
    private Integer sort;

    @ApiModelProperty("总销量")
    private Long numSale;

    @ApiModelProperty("好评率，好评数/总评价数")
    private BigDecimal rateEvalGood;


    @ApiModelProperty("商品主图")
    private String mainPicUrl;

    @ApiModelProperty(value = "图的文件编码")
    private String mainPicFileCode;

    @ApiModelProperty(value = "商品标题")
    private String title;

    @ApiModelProperty("明细")
    List<FirstSpecialItemVO> list;

    @ApiModelProperty("商品详情")
    private BipItemDetailAppRespVO bipItemDetailAppRespVO;

}
