package com.elitesland.sale.api.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "销售允发期保存")
public class AllowShipSaleSaveVO implements Serializable {
    private static final long serialVersionUID = -3235013523807353036L;



    @ApiModelProperty("id")
    private Long id;


    @ApiModelProperty("客户组编码")
    private String custGroupCode;

    @ApiModelProperty("客户编码")
    private String custCode;


    @ApiModelProperty("商品组编码")
    private String itemGroupCode;


    @ApiModelProperty("商品编码")
    private String itemCode;


    @ApiModelProperty("规则编码")
    private String ruleCode;

    @ApiModelProperty("生效时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validFromTime;

    @ApiModelProperty("失效时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validToTime;

}
