package com.elitesland.sale.api.vo.resp.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 收货地址
 */
@ApiModel(description = "客户收货地址信息")
@Data
public class CrmCustReceiveAddrRespVO implements Serializable {

    /**
     * 地址信息ID
     */
    @ApiModelProperty("地址信息ID")
    private Long id;

    /**
     * 地址薄地址号
     */
    @ApiModelProperty("地址薄地址号")
    private Long addrNo;

    /**
     * 地址薄名称
     */
    @ApiModelProperty("地址薄名称")
    private String addrName;

    /**
     * 地址薄类型:[UDC]ORG:ADDR_TYPE
     */
    @ApiModelProperty("地址薄类型:[UDC]ORG:ADDR_TYPE")
    private String addrType;

    /**
     * 地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE
     */
    @ApiModelProperty("地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE")
    private String addressType;

    /**
     * 是否默认：1是，0否
     */
    @ApiModelProperty("是否默认：1是，0否")
    private Boolean defaultFlag;

    /**
     * 联系人姓名
     */
    @ApiModelProperty("联系人姓名")
    private String contPerson;

    /**
     * 手机号码
     */
    @ApiModelProperty("手机号码")
    private String mobile;

    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String tel;

    /**
     * 传真
     */
    @ApiModelProperty("传真")
    private String fax;

    /**
     * 电邮
     */
    @ApiModelProperty("电邮")
    private String email;

    /**
     * 邮政编码
     */
    @ApiModelProperty("邮政编码")
    private String zipCode;

    /**
     * 国家
     */
    @ApiModelProperty("国家")
    private String country;
    private String countryName;

    /**
     * 省份(编号/ID)
     */
    @ApiModelProperty("省份(编号/ID)")
    private String province;
    @ApiModelProperty(value = "省份名称")
    private String provinceName;

    /**
     * 城市(编号/ID)
     */
    @ApiModelProperty("城市(编号/ID)")
    private String city;
    @ApiModelProperty(value = "城市名称")
    private String cityName;

    /**
     * 区县(编号/ID)
     */
    @ApiModelProperty("区县(编号/ID)")
    private String county;
    @ApiModelProperty(value = "区县名称")
    private String countyName;

    /**
     * 街道/乡镇(文本)
     */
    @ApiModelProperty("街道/乡镇(文本)")
    private String street;

    /**
     * 详细地址
     */
    @ApiModelProperty("详细地址")
    private String detailAddr;


    /**
     * 微信号
     */
    @ApiModelProperty("微信号")
    private String weChatNo;

    /**
     * qq号
     */
    @ApiModelProperty("qq号")
    private String qqNo;

}
