package com.elitesland.sale.api.vo.resp.contract;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 返回参数 - 销售合同Convert to Basic Latin查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 7:21 下午
 */
@ApiModel(description = "销售合同明细查询返回参数")
@Data
public class SaleContractToSoRespVO implements Serializable {

    private static final long serialVersionUID = -7988495247117046710L;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("公司id")
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户id")
    private Long custId;
    @ApiModelProperty("客户编码")
    private String custCode;
    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("业务员id")
    private Long agentEmpId;
    @ApiModelProperty("业务员编码")
    private String agentEmpCode;
    @ApiModelProperty("业务员名称")
    private String agentEmpName;
    @ApiModelProperty("结算方式")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String settleType;
    private String settleTypeName;
    @ApiModelProperty("结算方式其他说明")
    private String settleTypeRemark;
    @ApiModelProperty("起效日期")
    @SysCode(sys = "yst-fin", mod = "AGREEMENT_EFFECTIVE_DATE_TYPE")
    private String agreementEffectiveDateType;
    private String agreementEffectiveDateTypeName;
    @ApiModelProperty("账期天数")
    private Integer ardays;



    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("收款方式 [UDC]yst-supp:PAY_METHOD")
    private String payMethod;
    private String payMethodName;

    @ApiModelProperty("备注说明")
    private String remark;

    @ApiModelProperty("发货要求1")
    private String deliverInstruct;
    @ApiModelProperty("发货要求2")
    private String deliverInstruc2;

    @ApiModelProperty("商品信息")
    private List<SaleContractItemToSoRespVO> itemList;


}
