package com.elitesland.sale.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 客户简洁信息.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@Data
public class CrmCustSimpleDTO implements Serializable {
    private static final long serialVersionUID = 3808535255280957359L;

    /**
     * 客户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "客户ID")
    private Long id;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String custName;

    /**
     * 客户简称
     */
    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    /**
     * 联系人电话
     */
    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    /**
     * 联系人姓名
     */
    @ApiModelProperty(value = "联系人姓名")
    private String contactName;

    @ApiModelProperty(value = "账户余额")
    private BigDecimal balance;

    @ApiModelProperty(value = "客户状态")
    private String custStatus;
}
