package com.elitesland.sale.api.vo.resp.itm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

@Data
@ApiModel("响应sku")
public class ItmItemSkuRespVO implements Serializable {
    private static final long serialVersionUID = 3461857718986132158L;

    /**
     * spu上架ID = channelType_desId_spuId
     */
    private String spuOnShelfId;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("spuId")
    private Long spuId;

    @ApiModelProperty(value = "SKU商品编号")
    private String itemCode;

    @ApiModelProperty("商品规格(JSON字符串) [{\"code\":\"200007\",\"name\":\"尺码\",\"value\":\"大\"}]")
    private String itemAttr;

    /**
     * 详情页sku运算用
     */
    private Map<String, String> itemAttrMapByCode;
    /**
     * 详情页计算sku用
     */
    private List<SaleAttrVO> saleAttrList;

    @ApiModelProperty("SKU商品名称")
    private String itemName;

    @ApiModelProperty("条码")
    private String barCode;

    @ApiModelProperty("规格型号")
    private String spec;

    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty("车型 [UDC]ITM:ITEM_TYPE5")
    private String itemType5;
    private String itemType5Name;

    @ApiModelProperty("降价前价格")
    private BigDecimal beforeCutPrice;
    @ApiModelProperty("降价")
    private BigDecimal cutPrice;
    @ApiModelProperty("最终价格 = 降价前价格 - 降价")
    private BigDecimal finalPrice;

    @ApiModelProperty("SKU 图片")
    private List<ItmItemAttachmentRespVO> skuImages;

    @ApiModelProperty("即将下架日期")
    private LocalDateTime expRemovx;

    @ApiModelProperty("是否校验库存")
    private String shippingMethod;
}
