package com.elitesland.sale.api.vo.save.exter;

import com.elitesland.sale.api.vo.param.pro.SalContractDSaveParam;
import com.elitesland.sale.api.vo.param.pro.SalContractRecvSaveParam;
import com.elitesland.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/10/8 09:36
 */
@Data
@ApiModel(description = "销售合同保存")
public class SalContractSaveDTO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -3681107863268095892L;

    @ApiModelProperty(value = "合同编号")
    private String contractNo;

    @ApiModelProperty("外部合同号")
    @NotBlank(message = "外部合同号不得为空")
    private String contractNo2;

    @ApiModelProperty("合同版本")
    @NotNull(message = "合同版本不得为空")
    private Integer contractVersion;

    @ApiModelProperty(value = "合同名称", required = true)
    @NotBlank(message = "合同名称不得为空")
    private String contractName;

    @ApiModelProperty("项目id")
    private Long projId;

    @ApiModelProperty("项目编码")
    private String projCode;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("CRM项目编码")
    private String projCode2;

    @ApiModelProperty("合同类型")
    private String contractType;

    @ApiModelProperty("合同状态")
    private String contractStatus;

    @ApiModelProperty("合同质保期 数字N年")
    private String guaranteePeriod;

    @ApiModelProperty("城市")
    private String contractCity;

    @ApiModelProperty("费用承担方")
    private String feeCarrier;

    @ApiModelProperty(value = "交货时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate deliverDate;

    @ApiModelProperty("产品安装")
    private String installFlag;

    @ApiModelProperty("币种")
    @NotBlank(message = "币种不得为空")
    private String currCode;

    @ApiModelProperty(value = "签约日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;

    @ApiModelProperty(value = "开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate beginDate;

    @ApiModelProperty(value = "结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty("合同总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("交付详细地址")
    private String deliverAddress;

    @ApiModelProperty("是否需要项目验收")
    private Boolean projConfirmFlag;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "客户编号")
    private String custCode;

    @ApiModelProperty(value = "客户名称", required = true)
    @NotBlank(message = "客户名称不得为空")
    private String custName;

    @ApiModelProperty("客户联系人")
    private String custPic;

    @ApiModelProperty("客户联系人电话")
    private String custPicTel;

    @ApiModelProperty("客户地址")
    private String custAddress;

    @ApiModelProperty("签约公司名称")
    @NotBlank(message = "客户名称不得为空")
    private String ouName;

    @ApiModelProperty(value = "签约公司")
    private String bSignOu;
    private String bSignOuCode;
    private String bSignOuName;

    @ApiModelProperty(value = "签约部门")
    private String bSignDept;
    private String bSignDeptName;
    private String bSignDeptCode;

    @ApiModelProperty(value = "区域")
    private String region;
    private String bRegion;

    @ApiModelProperty(value = "销售员工号")
    private String salesmanCode;

    @ApiModelProperty("销售员")
    private String bSalesman;
    private String bSalesmanCode;

    @ApiModelProperty("销售员电话")
    private String salesmanTel;
    private String bSalesmanTel;

    @ApiModelProperty("签约公司地址")
    private String address;
    private String bAddress;

    @ApiModelProperty("合同明细 产品基本信息列表")
    private List<SalContractDSaveParam> itemDetails;

}
