package com.elitesland.sale.api.vo.param.sal;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/7/16 14:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "销售报价单查询入参")
public class SalPayDepositParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -3301938793376913550L;

    @ApiModelProperty("支付押金单号")
    private String docNo;

    @ApiModelProperty("支付押金类型  --退押金10和支付押金20")
    private String docType;

    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户name")
    private String custName;

    @ApiModelProperty("客户编码")
    private String custCode;


    @ApiModelProperty("申请人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("合同编号")
    private String contractNo;
    private List<String> contractNos;

    @ApiModelProperty("申请日期开始")
    private LocalDateTime applyDateBegin;

    @ApiModelProperty("申请日期结束")
    private LocalDateTime applyDateEnd;

    @ApiModelProperty("查询范围--全部 all  已退押金 depositRefunded 未退押金 unreturnedDeposit")
    private String queryRange;


    @ApiModelProperty("销售公司")
    private String ouName;

    @ApiModelProperty("销售公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

}
