package com.elitesland.sale.api.vo.resp.shop;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(description = "满赠赠品信息")
public class BipGiftVO implements Serializable {

    @ApiModelProperty(name = "赠品表id")
    private Long id;

    @ApiModelProperty(name = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "SKUid")
    private Long skuId;

    @ApiModelProperty(name = "skuCode")
    private String skuCode;

    @ApiModelProperty(name = "赠品id")
    private Long giftId;

    @ApiModelProperty(name = "赠品code")
    private String giftCode;

    @ApiModelProperty(name = "赠品name")
    private String giftName;

    @ApiModelProperty(value = "库存量")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long stockNum;

    @ApiModelProperty(value = "当前库存量")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long stockNowNum;

    @ApiModelProperty(value = "'促销条件:0 件数 1 金额")
    @SysCode(sys = "yst-sale", mod = "DISCOUNT_OFFSET_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("满赠达标金额")
    private BigDecimal limitAmt;

    @ApiModelProperty("满赠达标数量")
    private Long limitNum;

    @ApiModelProperty(value = "促销状态")
    @SysCode(sys = "yst-sale", mod = "DISCOUNT_OFFSET_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty(name = "买赠规则名称")
    private String mktName;

    @ApiModelProperty(name = "买赠规则编号")
    private String mktCode;
}
