package com.elitesland.sale.api.vo.param.pri;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @auther JinXK
 * @date 2021/7/13 10:08
 */
@Data
@ApiModel(description = "发货单明细查询请求参数")
public class RmiDoDParam implements Serializable {
    private static final long serialVersionUID = 4964823706656236752L;
    @ApiModelProperty("客户编码")
    private String custCode;
    @ApiModelProperty("客户Id")
    private Long custId;
    @ApiModelProperty("发货单编号")
    private String docNo;
    @ApiModelProperty("发货起始日期")
    private LocalDateTime docTimeStart;
    @ApiModelProperty("发货截止日期")
    private LocalDateTime docTimeEnd;
    @ApiModelProperty("签收起始日期")
    private LocalDateTime confirmTimeStart;
    @ApiModelProperty("签收截止日期")
    private LocalDateTime confirmTimeEnd;
    @ApiModelProperty("单据状态 [UDC]SAL:DO_STATUS")
    private String docStatus;
    @ApiModelProperty("对账状态")
    private String soaStatus;

    private Integer current;
    private Integer size;
}
