package com.elitesland.sale.api.vo.param.pri;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @auther JinXK
 * @date 2021/6/10 14:47
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "销售订单明细查询请求参数")
public class RmiSalSoDParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 2544113682538512842L;

    @ApiModelProperty(value = "销售单号")
    private String docNo;

    @ApiModelProperty(value = "合同编号")
    private String contractCode;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty(value = "客户ID")
    private Long custId;

    @ApiModelProperty(value = "单据状态")
    private String docStatus;

    @ApiModelProperty(value = "销售公司编号")
    private String ouCode;

    @ApiModelProperty(value = "开票状态")
    private String invStatus;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "过滤类型 AP(开票申请) RE(收款单) AR(账期收款)")
    private String type;

    private Integer current;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;
}
