package com.elitesland.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/26
 */
@Data
@ApiModel(description = "商品批量定时下架")
public class BipItemShelfOffSaveVO implements Serializable {
    private static final long serialVersionUID = -562985110554273507L;

    @ApiModelProperty(value = "商品记录ID", required = true, position = 1)
    @NotEmpty(message = "请选择商品")
    private List<Long> idList;

    @ApiModelProperty(value = "定时下架时间", position = 2)
    @NotNull(message = "下架时间为空")
    private LocalDateTime timeOffShelf;
}
