package com.elitesland.sale.api.vo.resp.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(description = "客户信息")
public class CrmCustBasePageVO implements Serializable {
    private static final long serialVersionUID = 7540510562120934979L;
    @ApiModelProperty("客户id")
    private Long id;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户号")
    private String custCode2;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("业务员id")
    private Long agentEmpId;

    @ApiModelProperty("业务员名称")
    private String agentEmpName;

    @ApiModelProperty("业务员编码")
    private String agentEmpCode;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("区域名称")
    private String regionName;

    @ApiModelProperty("地址号")
    private Long addrNo;

    @ApiModelProperty("省份(编号/ID)")
    private String province;
    @ApiModelProperty(value = "省份名称")
    private String provinceName;

    /**
     * 城市(编号/ID)
     */
    @ApiModelProperty("城市(编号/ID)")
    private String city;
    @ApiModelProperty(value = "城市名称")
    private String cityName;

    /**
     * 区县(编号/ID)
     */
    @ApiModelProperty("区县(编号/ID)")
    private String county;
    @ApiModelProperty(value = "区县名称")
    private String countyName;

    /**
     * 详细地址
     */
    @ApiModelProperty("详细地址")
    private String detailAddr;


}
