package com.elitesland.sale.api.vo.resp.shop;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 赠品表VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@ApiModel(description = "赠品表VO")
@Data
public class MktGiftRespVO implements Serializable {

    private static final long serialVersionUID = -3823436904938016687L;

    @ApiModelProperty(value = "赠品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("买赠折扣编码")
    private String discountGiftCode;

    @ApiModelProperty(value = "买赠明细商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long discountGiftItemId;

    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "库存量")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long stockNum;

    @ApiModelProperty(value = "当前库存量")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long stockNowNum;

    @ApiModelProperty(value = "库存锁定量")
    private Long lockNum;

    @ApiModelProperty(value = "生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty(value = "失效时间")
    private LocalDateTime validEtime;

    @ApiModelProperty(value = "商品sku编码")
    private String skuCode;

    @ApiModelProperty(value = "商品sku名称")
    private String skuName;

    @ApiModelProperty(value = "物料类型")
    private String materiel;
    private String materielName;

    @ApiModelProperty(value = "商品类型")
    private String type;
    private String typeName;

    @ApiModelProperty(value = "赠品数量")
    private Long giftNum;
}
