package com.elitesland.sale.api.vo.resp.taskinfo;

import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;


/**
 * @author : Wz
 * @date : 2023-5-19
 * @desc : 销售业绩统计-团队/个人业绩
 */
@Data
@ApiModel(description = "销售业绩统计-团队/个人业绩")
public class SaleStatisticsTeamRespVO extends BaseModelVO {

    /**
     * 汇总数量
     */
    @ApiModelProperty("汇总数量")
    private BigDecimal shipTotalQty;
    /**
     * 团队业绩
     */
    @ApiModelProperty("团队业绩")
    private BigDecimal teamPerformance;

    /**
     * 个人业绩
     */
    @ApiModelProperty("个人业绩")
    private BigDecimal personalPerformance;

    /**
     *业务员编码
     */
    @ApiModelProperty(value = "业务员编码")
    private String agentEmp;


}