package com.elitesland.sale.api.vo.save;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/11/17 22:11
 */
@Data
@ApiModel(description = "合同收款计划导入模板")
public class SalConRecvImportSaveVO implements Serializable {
    private static final long serialVersionUID = -6285296176720660706L;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("合同编码")
    private String contractNo;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("应收收款")
    private BigDecimal arAmt;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("应收日期")
    private LocalDate arDate;

    @ApiModelProperty("录入人")
    private String inputer;

    @ApiModelProperty("录入时间")
    private LocalDate inputDate;
    // 其他数据
    @ApiModelProperty("数据归属组织id")
    private Long secBuId;

    @ApiModelProperty("数据归属雇员id")
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    private Long secOuId;
}
