package com.elitesland.sale.api.vo.resp.salesman;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Danny.Wang
 * @title SalesmanSuperiorRespVO
 * @Date2023/2/23 9:33
 */
@Data
@ApiModel("业务员上级信息返回参数")
public class SalesmanSuperiorRespVO implements Serializable {

    @ApiModelProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "业务员编号")
    private String salesmanNo;

    @ApiModelProperty(value = "业务员名称")
    private String name;

    @ApiModelProperty(value = "业务员类型")
    private String type;
    private String typeName;

    @ApiModelProperty(value = "业务员表关联员工code")
    private String relateId;

    @ApiModelProperty(value = "员工id")
    private Long userId;
}
