package com.elitesland.sale.api.vo.param.contract;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 分页查询参数 - 项目合同分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-07 20:16:38
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "销售合同分页查询请求参数")
public class SaleContractItemParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 3507394458368618364L;

    @ApiModelProperty("合同号")
    private String contractNo;
    @ApiModelProperty("物料ID")
    private Long itemId;
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
}
