package com.elitesland.sale.api.service;

import com.elitesland.sale.api.vo.param.sal.SalPayDepositParamVO;
import com.elitesland.sale.api.vo.param.sal.SalPayDepositApproveParamVO;
import com.elitesland.sale.api.vo.resp.sal.SalPayDepositRespVO;
import com.elitesland.sale.api.vo.resp.sal.SalPayDepositReturnRespVO;
import com.elitescloud.cloudt.common.base.PagingVO;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/7/16 15:04
 */
public interface SalPayDepositService {

    /**
     * 支付押金分页查询
     *
     * @param searchParam searchParam
     */
    PagingVO<SalPayDepositRespVO> search(SalPayDepositParamVO searchParam);


    /**
     * 通过id查询支付押金详情
     * @param id id
     * @return SalPayDepositRespVO
     */
    SalPayDepositRespVO findSalPayDepositById(Long id);


    /**
     * 创建付押金
     * @param salPayDepositRespVO  salPayDepositRespVO
     * @return id
     */
    Long createSalPayDeposit(SalPayDepositRespVO salPayDepositRespVO);

    /**
     * 审批支付押金单
     * @param salPayDepositApproveParamVO SalPayDepositApproveParamVO
     * @param id id
     * @param docStatus docStatus
     * @return id
     *
     */
    Long approveSalPayDeposit(SalPayDepositApproveParamVO salPayDepositApproveParamVO);


    /**
     *  支付押金提交
     * @param salPayDepositRespVO  salPayDepositRespVO
     * @return id
     */
    Long submitSalPayDeposit(SalPayDepositRespVO salPayDepositRespVO);


    /**
     * 支付押金删除
     * @param id  id
     * @return id
     */
    Long  deleteSalPayDeposit(Long id);


    /**
     * 退支付押金单提交
     * @param salPayDepositReturnRespVO  SalPayDepositReturnRespVO
     * @return id
     */
    Long  refundSalQuotationSubmit(SalPayDepositReturnRespVO salPayDepositReturnRespVO);

    /**
     * 退支付押金单保存
     * @param salPayDepositReturnRespVO  SalPayDepositReturnRespVO
     * @return id
     */
    Long  refundSalQuotationSave(SalPayDepositReturnRespVO salPayDepositReturnRespVO);


    /**
     * 根据关联单号找到退押金单
     * @param docNo  单号
     * @return PagingVO PagingVO
     */
    PagingVO<SalPayDepositReturnRespVO> findRefundByPayDepositDocNo(String docNo);


    /**
     * 退支付押金单拒绝
     * @param salPayDepositApproveParamVO salPayDepositApproveParamVO
     * @param docStatus  单号
     * @param id  id
     * @return PagingVO PagingVO
     */
    Long refundSalQuotationRefuse(SalPayDepositApproveParamVO salPayDepositApproveParamVO);


    /**
     * 退支付押金单批准
     * @param salPayDepositApproveParamVO salPayDepositApproveParamVO
     * 退支付押金单拒绝
     * @param docStatus  单号
     * @param id  id
     * @return PagingVO PagingVO
     */
    Long refundSalQuotationApprove(SalPayDepositApproveParamVO salPayDepositApproveParamVO);


    /**
     * @param id id
     * @return id
     */
    SalPayDepositReturnRespVO refundSalQuotationQueryById (Long id);

}
