package com.elitesland.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.Application;
import com.elitesland.sale.api.vo.param.contract.*;
import com.elitesland.sale.api.vo.resp.contract.SaleContractItemAllPageRespVO;
import com.elitesland.sale.api.vo.resp.contract.SaleContractItemRpcVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 知原药业销售合同rpc接口
 *
 * @since 2025-09-25 14:46
 */
@FeignClient(name = Application.NAME, path = SaleContractRpcService.URI)
public interface SaleContractRpcService {
    String URI = Application.URI_PREFIX + "/saleContract";

    /**
     * 新增修改销售合同
     * id为null是新增，否则是修改
     *
     * @param param
     * @return
     */
    @PostMapping("/save")
    ApiResult<Long> save(@RequestBody SaleContractSaveParam param);


    /**
     * 新增修改销售合同
     * id为null是新增，否则是修改
     *
     * @param param
     * @return
     */
    @PostMapping("/queryContractItem")
    ApiResult<SaleContractItemRpcVO> queryContractItem(@RequestBody SaleContractItemParam param);


    /**
     * 检验销售合同明细已执行数量
     *
     * @param params
     * @return
     */
    @PostMapping("/checkContractExecutedQty")
    ApiResult<String> checkContractExecutedQty(@RequestBody List<SaleContractItemCheckParam> params);

    /**
     * 增加销售合同明细已执行数量
     *
     * @param params
     * @return
     */
    @PostMapping("/addContractExecutedQty")
    ApiResult<String> addContractExecutedQty(@RequestBody List<SaleContractItemCheckParam> params);
    /**
     * 校验并修改销售合同明细已执行数量和合同状态
     *
     * @param params
     * @return
     */
    @PostMapping("/updateContractExecutedQty")
    ApiResult<String> updateContractExecutedQty(@RequestBody List<SaleContractItemCheckParam> params);

    /**
     * 获取销售合同价格  主表字段不全
     *
     * @param param
     * @return
     */
    @PostMapping("/getSaleContractPrice")
    ApiResult<List<SaleContractItemRpcVO>> getSaleContractPrice(@RequestBody SaleContractItemPagingParam param);

    /**
     * 获取销售合同价格 返回全量关联的合同主表字段
     *
     * @param param
     * @return
     */
    @PostMapping("/getSaleContractPriceAll")
    ApiResult<List<SaleContractItemAllPageRespVO>> getSaleContractPriceAll(@RequestBody SaleContractItemPagingParam param);

}