package com.elitesland.sale.api.vo.resp.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel(value = "导出客户证照信息", description = "导出客户证照信息")
public class CustomerCertificateExportVO implements Serializable {
    @ApiModelProperty(value = "客户名称")
    private String custName;
    
    @ApiModelProperty(value = "客户编码")
    private String custCode;
    
    @ApiModelProperty(value = "地址号")
    private Long addrNo;
    
    @ApiModelProperty("证照编号(文件自己的编号)")
    private String qualifyNo;
    
    @ApiModelProperty(value = "资质类型名称")
    private String qualifyTypeName;
    
    @ApiModelProperty(value = "资质证照状态名称")
    private String qualifyStatusName;
    
    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;
    
    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;
    
    @ApiModelProperty("备注")
    private String remark;
}
