package com.elitesland.sale.api.vo.resp.contract;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class SaleContractItemAllPageRespVO extends BaseModelVOMedItem {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("记录唯一id")
    private Long id;
    @ApiModelProperty("主表ID")
    private Long masId;
    @ApiModelProperty("合同编号")
    private String docNo;
    @ApiModelProperty("合同名称")
    private String docName;
    @ApiModelProperty("合同编号")
    private String contractNo;
    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("公司id")
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户id")
    private Long custId;
    @ApiModelProperty("客户编码")
    private String custCode;
    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("业务员id")
    private Long agentEmpId;
    @ApiModelProperty("业务员编码")
    private String agentEmpCode;
    @ApiModelProperty("业务员名称")
    private String agentEmpName;

    @ApiModelProperty("主表币种")
    private String mainCurrCode;
    private String mainCurrCodeName;
    @ApiModelProperty("合同类型 [UDC]yst-sale:SALE_CONTRACT_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("签订日期")
    private LocalDateTime docDate;
    @ApiModelProperty("合同状态 [UDC]yst-sale:SALE_CONTRACT_STATUS")
    private String docStatus;
    private String docStatusName;

    /*@ApiModelProperty("付款协议类型")
    private String protocolType;
    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty("付款协议名称")
    private String protocolName;*/

    @ApiModelProperty("签订地点")
    private String signPlace;
    @ApiModelProperty("合同模板")
    @SysCode(sys = "yst-sale", mod = "SALE_CONTRACT_TEMPLATE")
    private String saleContractTemplate;
    private String saleContractTemplateName;
    @ApiModelProperty("合同来源")
    @SysCode(sys = "yst-sale", mod = "SALE_CONTRACT_SOURCE")
    private String saleContractSource;
    private String saleContractSourceName;
    @ApiModelProperty("结算方式")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String settleType;
    private String settleTypeName;
    @ApiModelProperty("起效日期")
    @SysCode(sys = "yst-fin", mod = "AGREEMENT_EFFECTIVE_DATE_TYPE")
    private String agreementEffectiveDateType;
    private String agreementEffectiveDateTypeName;
    @ApiModelProperty("账期天数")
    private Integer ardays;
    /*@ApiModelProperty("收款方式 [UDC]yst-supp:PAY_METHOD")
    private String payMethod;
    private String payMethodName;*/
    // @ApiModelProperty("流程实例状态[UDC]yst-sale:SALE_CONTRACT_APPLY_STATUS")
    // private String procInstStatus;
    // private String procInstStatusName;
    @ApiModelProperty("版本号")
    private BigDecimal versionNo;

    @ApiModelProperty("发货要求1")
    private String deliverInstruct;
    @ApiModelProperty("发货要求2")
    private String deliverInstruc2;
    @ApiModelProperty("是否归档")
    @SysCode(sys = "yst-purc", mod = "TRUE_OR_FALSE")
    private String archiveFlag;
    private String archiveFlagName;
    @ApiModelProperty("归档日期")
    private LocalDateTime archiveDate;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;



    // 公司基本信息
    @ApiModelProperty(value = "公司基本信息-法人代表")
    private String ouReprName;
    @ApiModelProperty(value = "公司基本信息-纳税人识别号")
    private String ouCertNo;
    @ApiModelProperty(value = "公司基本信息-开户银行")
    private String ouBankName;
    @ApiModelProperty(value = "公司基本信息-支行")
    private String ouBranchName;
    @ApiModelProperty(value = "公司基本信息-银行账号")
    private String ouBankAcc;
    @ApiModelProperty(value = "公司基本信息-联系人")
    private String ouContact;
    @ApiModelProperty(value = "公司基本信息-联系电话")
    private String ouMobile;
    @ApiModelProperty(value = "公司基本信息-联系人邮箱")
    private String ouEmail;
    @ApiModelProperty(value = "公司基本信息-国家")
    private String ouCountry;
    @ApiModelProperty(value = "公司基本信息-省")
    private String ouProvince;
    @ApiModelProperty(value = "公司基本信息-市")
    private String ouCity;
    @ApiModelProperty(value = "公司基本信息-区")
    private String ouCounty;
    @ApiModelProperty(value = "公司基本信息-地址")
    private String ouAddress;

    @ApiModelProperty("公司基本信息-发货人姓名")
    private String ouShipContact;
    @ApiModelProperty("公司基本信息-发货人电话")
    private String ouShipMobile;
    @ApiModelProperty("公司基本信息-发货人邮箱")
    private String ouShipEmail;
    @ApiModelProperty(value = "公司基本信息-发货人国家")
    private String ouShipCountry;
    @ApiModelProperty(value = "公司基本信息-发货人省")
    private String ouShipProvince;
    @ApiModelProperty(value = "公司基本信息-发货人市")
    private String ouShipCity;
    @ApiModelProperty(value = "公司基本信息-发货人区")
    private String ouShipCounty;
    @ApiModelProperty(value = "公司基本信息-发货人地址")
    private String ouShipAddress;

    // 客户基本信息
    @ApiModelProperty(value = "供应商基本信息-法人代表")
    private String custReprName;
    @ApiModelProperty(value = "供应商基本信息-纳税人识别号")
    private String custCertNo;
    @ApiModelProperty(value = "供应商基本信息-开户银行")
    private String custBankName;
    @ApiModelProperty(value = "供应商基本信息-支行")
    private String custBranchName;
    @ApiModelProperty(value = "供应商基本信息-银行账号")
    private String custBankAcc;
    @ApiModelProperty(value = "供应商基本信息-联系人")
    private String custContact;
    @ApiModelProperty(value = "供应商基本信息-联系电话")
    private String custMobile;
    @ApiModelProperty(value = "供应商基本信息-联系人邮箱")
    private String custEmail;
    @ApiModelProperty(value = "供应商基本信息-国家")
    private String custCountry;
    @ApiModelProperty(value = "供应商基本信息-省")
    private String custProvince;
    @ApiModelProperty(value = "供应商基本信息-市")
    private String custCity;
    @ApiModelProperty(value = "供应商基本信息-区")
    private String custCounty;
    @ApiModelProperty(value = "供应商基本信息-地址")
    private String custAddress;

    @ApiModelProperty("供应商基本信息-收货人姓名")
    private String custRecvContact;
    @ApiModelProperty("供应商基本信息-收货人电话")
    private String custRecvMobile;
    @ApiModelProperty("供应商基本信息-收货人邮箱")
    private String custRecvEmail;
    @ApiModelProperty(value = "供应商基本信息-收货人国家")
    private String custRecvCountry;
    @ApiModelProperty(value = "供应商基本信息-收货人省")
    private String custRecvProvince;
    @ApiModelProperty(value = "供应商基本信息-收货人市")
    private String custRecvCity;
    @ApiModelProperty(value = "供应商基本信息-收货人区")
    private String custRecvCounty;
    @ApiModelProperty(value = "供应商基本信息-收货人地址")
    private String custRecvAddress;

    @ApiModelProperty("物料ID")
    private Long itemId;

    @ApiModelProperty("物料编码")
    private String itemCode;

    @ApiModelProperty("物料名称")
    private String itemName;

    @ApiModelProperty("物料规格")
    private String itemSpec;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    @ApiModelProperty("要求发货日期")
    private LocalDateTime shipDate;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("订购单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;


    @ApiModelProperty("销售单价（订购单位）")
    private BigDecimal dgPrice;
    @ApiModelProperty("基本单位数量")
    private BigDecimal baseQty;

    @ApiModelProperty("基本单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String baseUom;
    private String baseUomName;

    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("品牌名称")
    private String brandName;

    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("商品SKU条码")
    private String barCode;

    @ApiModelProperty("体积")
    private BigDecimal volume;
    @ApiModelProperty("体积单位")
    private String volumeUnit;
    private String volumeUnitName;
    @ApiModelProperty("重量")
    private BigDecimal grossWeight;
    @ApiModelProperty("重量单位")
    private String weightUnit;
    private String weightUnitName;

    @ApiModelProperty("含税单价")
    private BigDecimal taxPrice;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("不含税价")
    private BigDecimal netPrice;

    @ApiModelProperty("币种")
    private String currCode;
    private String currName;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("备注")
    private String remark;


    @ApiModelProperty("渠道 yst-supp:SALE_CHANNEL")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String saleChannel;
    private String saleChannelName;
    @ApiModelProperty("已执行数量")
    private BigDecimal executedQty;

    @ApiModelProperty("中包装单位")
    private String uom3;
    @ApiModelProperty("大包装单位")
    private String uom4;
    @ApiModelProperty("中包装单位转换系数")
    private BigDecimal uomRatio3;
    @ApiModelProperty("大包装单位转换系数")
    private BigDecimal uomRatio4;
    @ApiModelProperty("收款协议类型")
    private String protocolType;
    @ApiModelProperty("收款协议编码")
    private String protocolCode;
    @ApiModelProperty("收款协议名称")
    private String protocolName;

  //补充的逐步字段
    @ApiModelProperty("合同金额大写")
    private String amtUpper;
    @ApiModelProperty("结算方式其他说明")
    private String settleTypeRemark;
    @ApiModelProperty("收款方式 [UDC]yst-supp:PAY_METHOD")
    private String payMethod;
    private String payMethodName;
    @ApiModelProperty("附件 编码逗号隔开")
    private String fileCodes;
    // 交付约定
    @ApiModelProperty(value = "交货方式")
    @SysCode(sys = "yst-purc", mod = "DELIVERY_METHOD")
    private String deliveryMethod;
    private String deliveryMethodName;
    @ApiModelProperty(value = "交货期限")
    private String deliveryDeadline;
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp", mod = "TP_TYPE")
    private String transType;
    private String transTypeName;
    @ApiModelProperty(value = "运费承担方")
    @SysCode(sys = "yst-purc", mod = "FREIGHT_PAYER")
    private String freightPayer;
    private String freightPayerName;
    @ApiModelProperty(value = "交货地点")
    private String deliveryLocation;
    // 验收约定
    @ApiModelProperty(value = "验收期限（天）")
    private Integer acceptanceTerm;
    @ApiModelProperty(value = "调整换货期限（天）")
    private Integer exchangeTerm;
    @ApiModelProperty(value = "验收不合格处理方式")
    @SysCode(sys = "yst-purc", mod = "UNQUALIFIED_HANDLING")
    private String unqualifiedHandling;
    private String unqualifiedHandlingName;
    @ApiModelProperty(value = "隐藏缺陷发现期限（天）")
    private Integer hiddenDefectTerm;
    @ApiModelProperty(value = "验收质量标准")
    private String acceptanceStandard;
    // 付款约定
    @ApiModelProperty(value = "付款方式：UDC:yst-sale:PAYMENT_METHOD")
    @SysCode(sys = "yst-sale", mod = "PAYMENT_METHOD")
    private String paymentMethod;
    private String paymentMethodName;
    @ApiModelProperty(value = "付款期限（天）")
    private Integer payTerm;
    @ApiModelProperty(value = "预付款比例（%）")
    private BigDecimal prepaymentRatio;
    @ApiModelProperty("开票期限")
    private Integer invoiceTerm;
}
