package com.elitesland.sale.api.vo.param.crm;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "销售允发期分页")
public class AllowShipSalePageParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 4401090981859462527L;

    @ApiModelProperty("id集合")
    private List<Long> ids;

    @ApiModelProperty("名称组编码")
    private String custGroupCode;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("商品组编码")
    private String itemGroupCode;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("规则编码")
    private String ruleCode;

    @ApiModelProperty("有效日期")
    private LocalDate validDate;

    @ApiModelProperty("生效时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validFromTime;

    @ApiModelProperty("失效时间")
    private LocalDate validToTime;


}
