package com.elitesland.sale.api.vo.resp.pri;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 请求参数 - 销售价格变更申请明细(通用)
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/26 4:37 下午
 */
@Data
@ApiModel(description = "销售价格变更申请明细参数(通用)")
public class PriSalePriceAlterDRespVO implements Serializable {
    private static final long serialVersionUID = -2148087809797887376L;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;
    @ApiModelProperty(value = "商品编码")
    @NotBlank(message = "商品编码不得为空")
    private String itemCode;
    @ApiModelProperty(value = "商品名称")
    private String itemName;
    @ApiModelProperty(value = "商品规格")
    private String itemSpec;
    @ApiModelProperty(value = "条码")
    private String barcode;

    @ApiModelProperty(value = "商品品类全路径")
    private String itemCatePath;
    @ApiModelProperty(value = "商品品类码")
    private String itemCateCode;

    @ApiModelProperty(value = "单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "市场价")
    private BigDecimal marketPrice;
    @ApiModelProperty(value = "指导价")
    private BigDecimal guidePrice;
    @ApiModelProperty(value = "销售底价")
    private BigDecimal floorPrice;

    @ApiModelProperty(value = "客户ID")
    private Long custId;
    @ApiModelProperty(value = "客户编码")
    private String custCode;
    @ApiModelProperty(value = "客户名称")
    private String custName;
    private String custLevel;  // 客户等级

    @ApiModelProperty(value = "对外基础价格申请使用")
    private BigDecimal basePrice;

    @ApiModelProperty(value = "客户价格申请使用")
    private BigDecimal custPrice;

    @ApiModelProperty(value = "客户等级价格申请使用")
    private BigDecimal custGroupPrice;

    @ApiModelProperty(value = "对内结算价申请使用")
    private BigDecimal crossPrice;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    @ApiModelProperty("税率描述")
    private String taxRateDesc;

    @ApiModelProperty("货币码")
    private String currCode;
    @ApiModelProperty("货币名称")
    private String currName;

    @ApiModelProperty(value = "生效时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "销售区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String saleRegion;
    private String saleRegionName;

    // 接收导入模板中填写的价格
    private String price;

    // 导入使用，不带时分秒
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validFromDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validToDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate promFromDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate promToDate;

    @ApiModelProperty(value = "活动价生效日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime promDateF;

    @ApiModelProperty(value = "活动价失效日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime promDateT;

    @ApiModelProperty("活动含税价格")
    private BigDecimal promotionPrice;

    @ApiModelProperty("活动不含税价格")
    private BigDecimal promotionNetPrice;


}
