package com.elitesland.sale.api.vo.save.exter;

import com.elitesland.sale.api.vo.save.CrmCustAddrSaveVO;
import com.elitesland.sale.api.vo.save.CrmCustQualifySaveVO;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.convert.BooleanToIntegerConverter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Convert;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/10/8 09:34
 */
@Data
@ApiModel(description = "客户数据保存")
public class CrmCustSaveDTO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -6355898960334725973L;

//    @ApiModelProperty(value = "客户id")
//    @JsonSerialize(using = ToStringSerializer.class)
//    private Long id;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "地址簿ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty(value = "外部系统客户编码")
    @NotNull(message = "外部系统客户编码")
    private String custCode2;

    @ApiModelProperty(value = "税务登记号")
    @NotNull(message = "税务登记号不能为空")
    private String taxRegNo;

    @ApiModelProperty(value = "工商登记号")
    private String icRegisterNo;

    @ApiModelProperty(value = "客户名称", required = true)
    @NotNull(message = "客户名称不能为空")
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司编号", required = true)
    @NotNull(message = "所属公司编码不能为空")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售组织ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    @ApiModelProperty(value = "销售组织编号")
    @NotNull(message = "销售组织编码不能为空")
    private String buCode;
    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty(value = "区域", required = true)
    private String region;

    @ApiModelProperty(value = "客户管理专员id", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @NotNull(message = "业务员员工号不能为空")
    private String agentEmpCode;

    @ApiModelProperty(value = "客户分类", required = true)
    @NotNull(message = "客户分类不能为空")
    private String custType;

    @ApiModelProperty(value = "客户状态")
    @NotNull(message = "客户状态不能为空")
    private String custStatus;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "客户行业")
    private String custIndustry;

    @ApiModelProperty(value = "客户来源")
    private String custSource;

    @ApiModelProperty(value = "客户规模")
    private String compScale;

    @ApiModelProperty(value = "客户年营业额")
    private String compTurnover;

    @ApiModelProperty(value = "客户归类")
    @NotNull(message = "客户归类不能为空")
    private String custType2;

    @ApiModelProperty(value = "发票类型")
    private String invType;


    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "税号")
    private String taxerNo;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    @ApiModelProperty(value = "银行账户")
    private String invBankAcc;

    @ApiModelProperty(value = "联系人")
    private String invPicName;

    @ApiModelProperty(value = "联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "付款条款")
    private String paymentTerm;

    @ApiModelProperty(value = "账期检查类型")
    private String ardaysCheckType;

    @ApiModelProperty(value = "账期检查类型名称")
    private String ardaysCheckTypeName;

    @ApiModelProperty(value = "信贷检查类型")
    private String creditCheckType;

    @ApiModelProperty(value = "信贷检查类型名称")
    private String creditCheckTypeName;

    @ApiModelProperty(value = "信贷额度")
    private BigDecimal creditLimit;

    @ApiModelProperty(value = "父项客户号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long pid;

    @ApiModelProperty(value = "税码")
    private String taxCode;

    @ApiModelProperty(value = "税率编码")
    private String taxRateNo;

    @ApiModelProperty(value = "默认税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "客户地址列表数据")
    private List<CrmCustAddrSaveVO> addrList;

    @ApiModelProperty(value = "证照信息列表数据")
    private List<CrmCustQualifySaveVO> qualifyList;

    @ApiModelProperty(value = "其他1")
    private String es2;

    @ApiModelProperty(value = "其他2")
    private String es3;

    @ApiModelProperty(value = "其他3")
    private String es4;

    @ApiModelProperty(value = "其他4")
    private String es5;

    @ApiModelProperty(value = "其他5")
    private String es6;

    @ApiModelProperty(value = "其他6")
    private String es7;

    @ApiModelProperty(value = "客户详情")
    private String custDesc;

//    @ApiModelProperty(value = "同步状态")
//    private String intfStatus;

//    @ApiModelProperty(value = "参保信息")
//    @NotNull(message = "参保信息不能为空")
//    private String insured;

    @ApiModelProperty(value = "类别码")
    private String cat;

    @ApiModelProperty(value = "类别码2")
    private String cat2;

    @ApiModelProperty(value = "类别码3")
    private String cat3;

    @ApiModelProperty(value = "类别码4")
    private String cat4;

    @ApiModelProperty(value = "类别码5")
    private String cat5;

    @ApiModelProperty(value = "类别码6")
    private String cat6;

    @ApiModelProperty(value = "类别码7")
    private String cat7;

    @ApiModelProperty(value = "类别码8")
    private String cat8;

    @ApiModelProperty(value = "类别码9")
    private String cat9;

    @ApiModelProperty(value = "类别码10")
    private String cat10;

    @ApiModelProperty(value = "大B/小B [UDC]CRM:CUST_GROUP2")
    private String custGroup2;

    @ApiModelProperty(value = "客户首次创建方")
    private Integer createdBy;

    @ApiModelProperty("联系人电话")
    private String contactPhone;

    @ApiModelProperty("联系人姓名")
    private String contactName;

    @ApiModelProperty("是否关联账户")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean isCreatedAccount;
}
