package com.elitesland.sale.api.vo.resp.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "销售允发期")
public class AllowShipSaleVO implements Serializable {
    private static final long serialVersionUID = -35509964824217714L;

    @ApiModelProperty("id")
    private Long id;


    @ApiModelProperty("客户组编码")
    private String custGroupCode;

    @ApiModelProperty("客户组名称")
    private String custGroupCodeName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("商品组编码")
    private String itemGroupCode;

    @ApiModelProperty("商品组名称")
    private String itemGroupName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("规则编码")
    private String ruleCode;

    @ApiModelProperty("规则名称")
    private String ruleName;

    @ApiModelProperty("生效时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validFromTime;

    @ApiModelProperty("失效时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validToTime;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

}
