package com.elitesland.sale.api.vo.resp.crm;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "客户基本信息+归属公司", description = "客户基本信息+归属公司")
public class CustBaseAndBelongOuDTO implements Serializable {
    private static final long serialVersionUID = 7750485941817044771L;

    /**
     * 客户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "客户ID")
    private Long id;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String custName;

    /**
     * 客户简称
     */
    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    /**
     * 联系人电话
     */
    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    /**
     * 联系人姓名
     */
    @ApiModelProperty(value = "联系人姓名")
    private String contactName;


    @ApiModelProperty(value = "客户状态")
    private String custStatus;

    @ApiModelProperty(value = "客户渠道")
    private String saleChannel;

    @ApiModelProperty(value = "业务员ID")
    private Long agentEmpId;

    @ApiModelProperty("付款条款")
    private String paymentTerm;

    private String preCustCode;

    private String preCustName;

    private String custDef;

    @ApiModelProperty(value = "客户归属公司")
    private List<CustBelongOuDTO> belongOuDTOS;
}
