package com.elitesland.sale.dto.save;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.convert.BooleanToIntegerConverter;
import com.elitesland.sale.api.vo.save.OrgAddrBankAccSaveVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/15 10:40
 */
@ApiModel(description = "客户信息")
@Data
public class CrmCustRpcSaveDto implements Serializable {

    private static final long serialVersionUID = 8885780201806144401L;
    /**
     * 客户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 客户编码
     */
    private String custCode;

    /**
     * 地址簿ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    /**
     * 地址号
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    /**
     * 外部系统客户编码
     */
    private String custCode2;

    /**
     * 税务登记号
     */
    @NotNull(message = "税务登记号不得为空")
    private String taxRegNo;

    /**
     * 工商登记号
     */
    private String icRegisterNo;

    /**
     * 客户名称
     */
    @NotNull(message = "客户名称不得为空")
    private String custName;

    /**
     * 客户简称
     */
    private String custAbbr;

    /**
     * 英文名称
     */
    private String custName2;

    /**
     * 公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 公司编码
     */
    private String ouCode;

    /**
     * 公司名称
     */
    private String ouName;

    /**
     * 销售组织ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 销售组织编号
     */
    private String buCode;

    /**
     * 销售组织名称
     */
    private String buName;

    /**
     * 销售区域
     */
    @NotNull(message = "销售区域不得为空")
    private String region;

    /**
     * 客户管理专员id
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    /**
     * 客户分类
     */
    @NotNull(message = "客户分类不得为空")
    private String custType;

    /**
     * 客户状态
     */
    private String custStatus;

    /**
     * 客户等级
     */
    private String custLevel;

    /**
     * 客户行业
     */
    private String custIndustry;

    /**
     * 客户来源
     */
    private String custSource;

    /**
     * 客户规模
     */
    private String compScale;


    /**
     * 客户年营业额
     */
    private String compTurnover;

    /**
     * 客户归类
     */
    @NotNull(message = "客户归类不得为空")
    private String custType2;

    /**
     * 发票类型
     */
    //@NotNull(message = "发票类型不得为空")
    private String invType;

    /**
     * 财务属性
     */
    @NotNull(message = "财务属性1不得为空")
    private String financialAttribute;

    /**
     * 财务属性2
     */
    private String financialAttribute2;

    /**
     * 财务属性3
     */
    private String financialAttribute3;

    /**
     * 财务属性4
     */
    private String financialAttribute4;

    /**
     * 财务属性5
     */
    private String financialAttribute5;

    /**
     * 财务属性组合
     */
    @NotNull(message = "财务属性组合不得为空")
    private String financialGroup;

    /**
     * 开票抬头
     */
    //@NotNull(message = "开票抬头不得为空")
    private String invTitle;

    /**
     * 税号
     */
    //@NotNull(message = "税号不得为空")
    private String taxerNo;

    /**
     * 开票地址
     */
    private String invAddress;

    /**
     * 开票电话
     */
    private String invTel;

    /**
     * 开户银行
     */
    private String invBankName;

    /**
     * 银行账户
     */
    private String invBankAcc;

    /**
     * 联系人
     */
    private String invPicName;


    /**
     * 联系人电话
     */
    private String invPicPhone;

    /**
     * 付款条款
     */
    private String paymentTerm;

    /**
     * 账期检查类型
     */
    private String ardaysCheckType;

    /**
     * 账期检查类型名称
     */
    private String ardaysCheckTypeName;

    /**
     * 信贷检查类型
     */
    private String creditCheckType;

    /**
     * 信贷检查类型名称
     */
    private String creditCheckTypeName;

    /**
     * 信贷额度
     */
    private BigDecimal creditLimit;

    /**
     * 父项客户号
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private String pid;

    /**
     * 税码
     */
    private String taxCode;

    /**
     * 税率编码
     */
    private String taxRateNo;

    /**
     * 默认税率
     */
    private BigDecimal taxRate;

    /**
     * 客户地址列表数据
     */
    private List<CrmCustRpcAddrSaveDto> addrList;

    /**
     * 证照信息列表数据
     */
    private List<CrmCustQualifyRpcSaveDto> qualifyList;


    /**
     * 其他
     */
    private String es2;

    /**
     * 其他
     */
    private String es3;

    /**
     * 其他
     */
    private String es4;

    /**
     * 其他
     */
    private String es5;

    /**
     * 其他
     */
    private String es6;

    /**
     * 其他
     */
    private String es7;

    /**
     * 客户详情
     */
    private String custDesc;

    /**
     * 同步状态
     */
//    private String intfStatus;


    /**
     * 类别码
     */
    private String cat;

    /**
     * 类别码
     */
    private String cat2;

    /**
     * 类别码
     */
    private String cat3;

    /**
     * 类别码
     */
    private String cat4;

    /**
     * 类别码
     */
    private String cat5;

    /**
     * 类别码
     */
    private String cat6;

    /**
     * 类别码
     */
    private String cat7;

    /**
     * 类别码
     */
    private String cat8;

    /**
     * 类别码
     */
    private String cat9;

    /**
     * 类别码
     */
    private String cat10;

    /**
     * 大B/小B [UDC]CRM:CUST_GROUP2
     */
    @NotNull(message = "大B/小B不得为空")
    private String custGroup2;

    /**
     * 客户首次创建方
     */
    private Integer createdBy;

    /**
     * B端小程序账户联系人电话
     */
    private String contactPhone;

    /**
     * B端小程序账户联系人
     */
    private String contactName;

    /**
     * 是否关联账户
     */
    private Boolean isCreatedAccount;

    @ApiModelProperty("银行信息保存列表")
    List<CrmCustBankRpcSaveDto> orgAddrBankAccList;
    /**
     * 客户定义
     */
    private String custDef;

    @ApiModelProperty("销售模式")
    private String saleMode;

    /**
     * 销售渠道
     */
    private String saleChannel;

    //增加

    @ApiModelProperty(value = "客户联系人")
    private String contPerson;

    @ApiModelProperty(value = "客户联系人手机")
    private String contPersonMobile;

    @ApiModelProperty(value = "客户联系人电话")
    private String contPersonTel;

    @ApiModelProperty(value = "客户联系人邮箱")
    private String contPersonEmail;

    @ApiModelProperty(value = "客户联系人省市区")
    private List<String> contractCity;
    private String contractCityName;

    @ApiModelProperty(value = "客户联系人详细地址")
    private String addrDetail;

    @ApiModelProperty(value = "业务员编码")
    private String agentEmpCode;

    @ApiModelProperty(value = "业务员名称")
    private String agentEmpName;

    @ApiModelProperty(value = "乡镇/街道")
    private String street;

    @ApiModelProperty(value = "客户联系人传真")
    private String contPersonFax;


    //lm
    @ApiModelProperty(value = "K3客户编码")
    private String outerCode;
    @ApiModelProperty(value = "客户分类")
    private String custGroup;
    private String custGroupName;

    @ApiModelProperty(value = "父项客户号")
    private String pid2;
    private String pidName;
    @ApiModelProperty(value = "统一社会信用代码")
    private String certNo;
    @ApiModelProperty(value = "结算币种")
    private String custCurr;
    @ApiModelProperty(value = "结算币种")
    private String custCurrName;

    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerType;
    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerTypeName;

    @ApiModelProperty(value = "错误信息")
    private String es1;

    @ApiModelProperty(value = "对应公司")
    private String corBusinCode;

    @ApiModelProperty(value = "客户登录帐号")
    private String userName;

    @ApiModelProperty(value = "允发最大批次数量")
    @SysCode(sys = "yst-sale", mod = "ALLOW_SHIP_BATCH_MAX")
    private String allowBatchMax;
    private String allowBatchMaxName;

    @ApiModelProperty(value = "默认允发期code")
    private String allowShipRuleCode;

    @ApiModelProperty(value = "默认允发期code")
    private String allowShipRuleName;

    private String saleChannelName;
    @ApiModelProperty("默认配送方式 yst-order:SO_DELIVER_METHOD")
    private String deliverMethod;
    private String deliverMethodName;

    @ApiModelProperty("承运信息")
    private String carrier;

    private String custDefName;

    private String saleModeName;

    @ApiModelProperty("法人代表")
    private String repr;

    @ApiModelProperty("法人联系方式")
    private String reprCertMobile;

    private String catName;

    @ApiModelProperty("类别码2")
    private String catName2;

    @ApiModelProperty("类别码3")
    private String catName3;

    @ApiModelProperty("类别码4")
    private String catName4;

    @ApiModelProperty("类别码5")
    private String catName5;

    @ApiModelProperty("类别码6")
    private String catName6;

    @ApiModelProperty("类别码7")
    private String catName7;

    @ApiModelProperty("类别码8")
    private String catName8;

    @ApiModelProperty("类别码9")
    private String catName9;

    @ApiModelProperty("类别码10")
    private String catName10;

    @ApiModelProperty("类别码11")
    private String cat11;
    private String catName11;

    @ApiModelProperty("类别码12")
    private String cat12;
    private String catName12;

    @ApiModelProperty("类别码13")
    private String cat13;
    private String catName13;

    @ApiModelProperty("类别码14")
    private String cat14;
    private String catName14;

    @ApiModelProperty("类别码15")
    private String cat15;
    private String catName15;

    @ApiModelProperty("类别码16")
    private String cat16;
    private String catName16;

    @ApiModelProperty("类别码17")
    private String cat17;
    private String catName17;

    @ApiModelProperty("类别码18")
    private String cat18;
    private String catName18;

    @ApiModelProperty("类别码19")
    private String cat19;
    private String catName19;

    @ApiModelProperty("类别码20")
    private String cat20;
    private String catName20;

    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-sale", mod = "CUST_IN_OUT")
    private String inOutCust;
    private String inOutCustName;
    @ApiModelProperty(value = "客户创建时，客户创建入口来源（当前内部使用，不建udc），00:门店创建时字段创建客户")
    private String createFrom;

    @ApiModelProperty("来源外部接口标记")
    private String source;
}
