package com.elitesland.sale.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * <p>
 * 金额数据序列化：
 * </p>
 *
 * @author ssy
 * @since 2021/8/19
 */
public class AmtBigDecimalJsonSerialize extends JsonSerializer<BigDecimal> {

    @Override
    public void serialize(BigDecimal value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeNumber(value == null ? BigDecimal.ZERO : value.setScale(2, RoundingMode.DOWN));
    }
}