package com.elitesland.sale.api.vo.param.contract;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 分页查询参数 - 项目合同分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-07 20:16:38
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "销售合同分页查询请求参数")
public class SaleContractPagingParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 3507394458368618364L;

    @ApiModelProperty("ID")
    private List<Long> ids;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("合同名称")
    private String docName;

    @ApiModelProperty("合同编号")
    private String docNo;


    @ApiModelProperty("合同类型 [UDC]PUR:PC_TYPE")
    private String docType;

    @ApiModelProperty("合同状态 [UDC]PUR:PC_STATUS")
    private String docStatus;


    @ApiModelProperty("流程实例状态")
    private String procInstStatus;

    @ApiModelProperty("签订日期")
    private LocalDateTime docDateFrom;
    @ApiModelProperty("签订日期")
    private LocalDateTime docDateTo;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("业务员编码")
    private String agentEmpCode;

}
