package com.elitesland.sale.api.vo.param.contract;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class SaleContractSaveParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("合同编号")
    private String docNo;

    @ApiModelProperty("合同名称")
    private String docName;

    @ApiModelProperty("合同类型 [UDC]yst-sale:SALE_CONTRACT_TYPE")
    private String docType;

    @ApiModelProperty("合同状态 [UDC]SALE:SALE_CONTRACT_STATUS")
    private String docStatus;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private String procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("审批人ID")
    private Long apprUserId;

    @ApiModelProperty("审批人")
    private String apprUserName;

    @ApiModelProperty("签订日期")
    private LocalDateTime docDate;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("业务员ID")
    private Long agentEmpId;
    @ApiModelProperty("业务员编码")
    private String agentEmpCode;
    @ApiModelProperty("业务员名称")
    private String agentEmpName;

    @ApiModelProperty("付款协议类型")
    private String protocolType;
    @ApiModelProperty("付款协议编码")
    private String protocolCode;

    @ApiModelProperty("收款方式 [UDC]yst-supp:PAY_METHOD")
    private String payMethod;

    @ApiModelProperty("发货要求1")
    private String deliverInstruct;
    @ApiModelProperty("发货要求2")
    private String deliverInstruc2;
    @ApiModelProperty("是否以归档  UDC:PUR:TRUE_OR_FALSE")
    private String archiveFlag;

    @ApiModelProperty("商品信息")
    private List<SaleContractItemSaveParam> itemSaveParamList;
    @ApiModelProperty("版本信息")
    private SaleContractVersionSaveParam version;
    @ApiModelProperty("合同条款信息")
    private List<SaleContractTermsSaveParam> termsSaveParamList;
    @ApiModelProperty("附件 编码逗号隔开")
    private String fileCodes;

    @ApiModelProperty("备注")
    private String remark;
}
