package com.elitesland.sale.api.vo.resp.contract;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 返回参数 - 销售合同分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 7:21 下午
 */
@ApiModel(description = "销售合同分页查询返回参数")
@Data
public class SaleContractPageRespVO implements Serializable {

    private static final long serialVersionUID = -7988495247117046710L;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("公司id")
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户id")
    private Long custId;
    @ApiModelProperty("客户编码")
    private String custCode;
    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("合同名称")
    private String docName;

    @ApiModelProperty("合同编号")
    private String docNo;


    @ApiModelProperty("合同类型 [UDC]yst-sale:SALE_CONTRACT_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("签订日期")
    private LocalDateTime docDate;
    @ApiModelProperty("合同状态 [UDC]yst-sale:SALE_CONTRACT_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("付款协议类型")
    private String protocolType;
    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty("付款协议名称")
    private String protocolName;

    @ApiModelProperty("收款方式 [UDC]yst-supp:PAY_METHOD")
    private String payMethod;
    private String payMethodName;

    @ApiModelProperty("流程实例状态[UDC]yst-sale:SALE_CONTRACT_APPLY_STATUS")
    private String procInstStatus;
    private String procInstStatusName;
    @ApiModelProperty("版本号")
    private BigDecimal versionNo;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("发货要求1")
    private String deliverInstruct;
    @ApiModelProperty("发货要求2")
    private String deliverInstruc2;
    @ApiModelProperty("是否归档")
    @SysCode(sys = "yst-purc", mod = "TRUE_OR_FALSE")
    private String archiveFlag;
    private String archiveFlagName;
    @ApiModelProperty("归档日期")
    private LocalDateTime archiveDate;
    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("业务员id")
    private Long agentEmpId;
    @ApiModelProperty("业务员编码")
    private String agentEmpCode;
    @ApiModelProperty("业务员名称")
    private String agentEmpName;
    @ApiModelProperty("创建人")
    private String creator;
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty("更新人")
    private String updater;
    @ApiModelProperty("更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("备注")
    private String remark;
}
