package com.elitesland.sale.api.vo.resp.component;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author: ryan.xu
 * @since 2023/6/25
 */
@Data
@ApiModel("业务员公共组件分页VO")
public class SalesmanPageRespVO implements Serializable {
    private static final long serialVersionUID = -8634920363032431031L;

    /**
     * 员工ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("业务员ID")
    private Long id;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "业务员编号")
    private String empCode;

    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "业务员姓名")
    private String empName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属组织ID")
    private Long buId;

    /**
     * 所属组织编号
     */
    @ApiModelProperty(value = "所属组织编号")
    private String buCode;

    /**
     * 所属组织名称
     */
    @ApiModelProperty(value = "所属组织名称")
    private String buName;

    /**
     * 所属公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属公司ID")
    private Long ouId;

    /**
     * 所属公司名称
     */
    @ApiModelProperty(value = "所属公司名称")
    private String ouName;

    /**
     * 所属公司编号
     */
    @ApiModelProperty(value = "所属公司编号")
    private String ouCode;

    /**
     * 公司本位币
     */
    @ApiModelProperty(value = "公司本位币")
    private String currCode;
    @ApiModelProperty(value = "公司本位币名称")
    private String currName;

    /**
     * 员工绑定的用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "业务员绑定的用户ID")
    private Long userId;

    /**
     * 员工绑定的用户名
     */
    @ApiModelProperty(value = "业务员绑定的用户名")
    private String userName;

    /**
     * 地址号
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("地址号")
    private Long addrNo;
    @ApiModelProperty("业务员ID")
    private Long agentEmpId;
    @ApiModelProperty("业务员名称")
    private String agentEmpName;
    @ApiModelProperty("业务员编码")
    private String agentEmpCode;

}
