package com.elitesland.sale.api.vo.resp.crm;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.component.SalesmanComponentPageRespVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@ApiModel(description = "客户弹框选择")
@Data
public class CrmCustPlugInRespVO implements Serializable {

    private static final long serialVersionUID = -6749080322667143862L;
    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;
    
    @ApiModelProperty(value = "父客户编码")
    private String preCustCode;
    
    @ApiModelProperty(value = "父客户名称")
    private String preCustName;
    
    @ApiModelProperty(value = "客户定义")
    private String custDef;
    
    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "客户类型")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custType;
    @ApiModelProperty(value = "客户类型name")
    private String custTypeName;

    @ApiModelProperty(value = "业务员id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;



    @ApiModelProperty(value = "业务员name")
    private String agentEmpName;

    @ApiModelProperty(value = "业务员Code")
    private String agentEmpCode;


    @ApiModelProperty(value = "客户联系人")
    private String custContactName;

    @ApiModelProperty(value = "客户联系人电话")
    private String custContactTel;

    @ApiModelProperty(value = "客户联系人邮箱")
    private String custContactEmail;

    @ApiModelProperty(value = "客户组")
    private String custGroup;

    @ApiModelProperty(value = "币种")
    private String currCode;

    @ApiModelProperty(value = "客户联系人详细地址")
    private String addrDetail;

    @ApiModelProperty(value = "付款方式")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String payMethod;
    @ApiModelProperty(value = "付款方式Name")
    private String payMethodName;

    @ApiModelProperty(value = "付款条款")
    @SysCode(sys = "yst-supp", mod = "PAYMENT_TERM")
    private String paymentTerm;
    private String paymentTermName;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long recvAddrNo;

    @ApiModelProperty(value = "地址ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    @ApiModelProperty(value = "收货国家")
    private String recvCountry;

    @ApiModelProperty(value = "收货省")
    private String recvProvince;

    @ApiModelProperty(value = "收货省名字")
    private String recvProvinceName;

    @ApiModelProperty(value = "收货市")
    private String recvCity;

    @ApiModelProperty(value = "收货市名字")
    private String recvCityName;

    @ApiModelProperty(value = "收货区/县")
    private String recvCounty;

    @ApiModelProperty(value = "收货区/县名字")
    private String recvCountyName;

    @ApiModelProperty(value = "收货乡镇街道")
    private String receiveStreet;

    @ApiModelProperty(value = "省市区街")
    private List<String> recvRegion;

    @ApiModelProperty(value = "区域")
    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;
    @ApiModelProperty(value = "区域Name")
    private String regionName;

    @ApiModelProperty(value = "项目公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "项目公司id")
    private String ouCode;

    @ApiModelProperty(value = "项目公司名称")
    private String ouName;

    @ApiModelProperty(value = "buId")
    private Long buId;

    @ApiModelProperty(value = "buCode")
    private String buCode;

    @ApiModelProperty(value = "buName")
    private String buName;

    @ApiModelProperty("客户 ID")
    private String id;

    @ApiModelProperty("客户归类")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE2")
    private String custType2;
    @ApiModelProperty("客户归档名称")
    private String custType2Name;

    @ApiModelProperty("发票类型")
    @SysCode(sys = "yst-supp", mod = "INV_TYPE")
    private String invType;
    @ApiModelProperty("发票类型名称")
    private String invTypeName;

    @ApiModelProperty("开票抬头")
    private String invTitle;

    @ApiModelProperty("税号")
    private String taxerNo;

    @ApiModelProperty("开票地址")
    private String invAddress;

    @ApiModelProperty("开票电话")
    private String invTel;

    @ApiModelProperty("联系人电话")
    private String invPicPhone;

    @ApiModelProperty("开户银行")
    private String invBankName;

    @ApiModelProperty("银行账户")
    private String invBankAcc;

    @ApiModelProperty("联系人")
    private String invPicName;

    @ApiModelProperty("渠道 yst-supp:SALE_CHANNEL")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String saleChannel;
    private String saleChannelName;
    @ApiModelProperty("默认配送方式 yst-order:SO_DELIVER_METHOD")
    @SysCode(sys = "yst-order", mod = "SO_DELIVER_METHOD")
    private String deliverMethod;
    private String deliverMethodName;

    @ApiModelProperty("承运信息")
    private String carrier;

    @ApiModelProperty("业务员")
    private SalesmanComponentPageRespVO salemanInfo;

    @ApiModelProperty(value = "关联公司")
    private String corBusinCode;

    @SysCode(sys = "yst-sale", mod = "CUST_STATUS")
    private String custStatus;
    private String custStatusName;

    private List<CustBelongOuVO> belongOus;

    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-sale", mod = "CUST_IN_OUT")
    private String inOutCust;
    private String inOutCustName;

}
